function AdminTopologyPage(adminPage, $content) {
  PageFragment.call(this, $content);

  this.adminPage = adminPage;
  
  this.kEntryTemplate = kendo.template(tmc.getTemplate("#clusterReloadStatusEntry").html());
  this.$button = $content.find('#reloadButton').click($.proxy(this.handleReload, this));
  
  var $contentArea = $content.find('#reloadContentArea');
  
  this.$resultArea = $content.find('#resultArea');
  this.$resultTable = this.$resultArea.find('table');
  
  tmc.resizeHandler($content, function() {
    tmc.assignRemainingHeight($contentArea);
  });
}

AdminTopologyPage.prototype = $.extend({}, PageFragment.prototype, {
  getGroupPage: function() {
    return this.adminPage.getGroupPage();
  },

  getConnectionGroup: function() {
    return this.getGroupPage().getConnectionGroup();
  },

  handleReload: function(e) {
    var that = this;
    
    this.$button.addClass('k-state-disabled');
    this.$resultArea.hide();
    
    $.ajax({
      type: "POST",
      url: tmc.encodeURI(this.buildRequest()),
      dataType: "json",
      cancelable: false
    }).done(function(data) {
      that.handleResult(data);
    }).error(function(jqXHR, textStatus, errorThrown) {
      alert(textStatus);
    }).always(function() {
      that.$button.removeClass('k-state-disabled');
    });
  },

  handleResult: function(data) {
    if (data != null) {
      var that = this,
        $tbody = this.$resultTable.find('tbody');
      
      $tbody.empty();
      $.each(data, function(i, entry) {
        var stripe = tmc.getGroupForServer(that.getConnectionGroup(), entry.sourceId);
        entry.stripe = (stripe != null) ? stripe.name : "";
        $tbody.append(that.kEntryTemplate(entry));
      });
      this.$resultArea.show();
    }
  },
  
  buildRequest: function() {
    return 'api/agents;ids=' + this.adminPage.getClusterId() + '/diagnostics/reloadConfiguration';
  }
});