function AdminLogsPage(adminPage, $content) {
  PageFragment.call(this, $content);

  this.adminPage = adminPage;

  var that = this;
  
  this.$msgLabel = $content.find('#msgLabel');
  this.$pauseLink = $content.find('a#pause');
  this.$resumeLink = $content.find('a#resume');
  this.$textarea = $content.find('textarea');
  this.serverLogs = {}; /* serverName -> {logEntryArray, scrollPos} */
  this.initialized = false;
  this.skipRefresh = false;
  this.$body = $('body');
  
  var $contentHolder = $content.find('#contentHolder');
  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight($contentHolder);
  });

  this.scrollEventHandlers = {
    "scrollstart": function(e) {
      tmc.suspend();
    },
    "scrollstop": function(e) {
      that.skipRefresh = that.isScrolledAway();
      that.updateScrollPos();
      that.setPaused(that.skipRefresh);
      tmc.resume();
    }
  };
  
  this.$textarea.bind($.extend({}, {
    "select": function() {
      that.setPaused(that.skipRefresh = true);
    }
  }, this.scrollEventHandlers));

  this.$pauseLink.click(function() {
    that.setPaused(that.skipRefresh = true);
  });
  this.$resumeLink.click(function() {
    that.scrollToEnd();
    that.setPaused(that.skipRefresh = false);
  });
  
  ClusterPageFragment.call(this, $content, {
    selectorOptions: {showClients: false},
    optionLabel: 'Select a server...'
  });
}

AdminLogsPage.prototype = $.extend({}, PageFragment.prototype, ClusterPageFragment.prototype, {
  getGroupPage: function() {
    return this.adminPage.getGroupPage();
  },

  setPaused: function(paused) {
    if (paused) {
      this.$pauseLink.html('Paused')
        .addClass('disable-link')
        .removeClass('enable-link')
        .removeAttr('href')
        .show();
      this.$resumeLink.show();
    } else {
      this.$pauseLink.html('Pause')
        .removeClass('disable-link')
        .addClass('enable-link')
        .attr('href', "#")
        .show();
      this.$resumeLink.hide();
    }
  },
  
  testScopeSelection: function(e) {
    var kScopeSelector = this.scopeSelector.kScopeSelector,
      data = kScopeSelector.dataItem(e.item.index());
    
    if (data.type != this.scopeSelector.SERVER) {
      e.preventDefault();
    }
  },
  
  show: function() {
    PageFragment.prototype.show.call(this);
    
    if (this.initialized == false) {
      this.initialized = true;
      this.scopeSelector.handleOpening();
      this.handleScopeSelection();
    }
  },

  clearTextArea: function() {
    this.$textarea.text('');
  },

  getLogInfoForServer: function(serverName) {
    return this.serverLogs[serverName];
  },
  
  getLogEntriesForServer: function(serverName) {
    var logInfo = this.getLogInfoForServer(serverName);
    return (logInfo != null) ? logInfo.logEntries : null;
  },
  
  lastTimestamp: function(serverName) {
    var logEntries = this.getLogEntriesForServer(serverName);
    
    if (logEntries != null && logEntries.length > 0) {
      return logEntries[logEntries.length-1].timestamp;
    }
    
    return null;
  },
  
  buildRequest: function(dataItem) {
    var clusterID = this.adminPage.getClusterId(),
      suffix = "",
      lastTimestamp = this.lastTimestamp(dataItem.name);
    
    if (lastTimestamp != null) {
      var millis = $.now() - lastTimestamp,
         sinceSeconds = Math.ceil(millis/1000);
      suffix = '?sinceWhen=' + sinceSeconds + 's'; 
    }
    
    return 'api/agents;ids=' + clusterID + '/logs;names=' + dataItem.name + suffix;
  },
  
  handleResponse: function(data) {
    var that = this,
      dataItem = this.scopeSelector.dataItem(),
      logEntries = this.getLogEntriesForServer(dataItem.name),
      lastTimestamp = this.lastTimestamp(dataItem.name),
      newEntries = [];
    
    if (logEntries == null) {
      var logInfo = this.serverLogs[dataItem.name] = {};
      logEntries = logInfo.logEntries = [];
      logInfo.scrollPos = 0;
    }
    
    if (data != null && data.length > 0) {
      data.sort(function(a, b) {
        if (a.timestamp < b.timestamp) {
          return -1;
        } else if (a.timestamp > b.timestamp) {
          return 1;
        }
        return 0;
      });
      
      $.each(data, function(i, value) {
        if (value.timestamp > lastTimestamp) {
          logEntries.push(value);
          newEntries.push(value.message);
        }
      });

      this.$textarea.unbind(this.scrollEventHandlers);
      that.$textarea.append(newEntries.join(""));
      this.scrollToEnd();
      this.$textarea.bind(this.scrollEventHandlers);
      
      this.skipRefresh = false;
    }
  },
  
  updateScrollPos: function() {
    var dataItem = this.scopeSelector.dataItem();

    if (dataItem != null) {
      var logInfo = this.getLogInfoForServer(dataItem.name);
      
      if (logInfo != null) {
        logInfo.scrollPos = this.getScrollTop();
      }
    }
  },
  
  getScrollTop: function() {
    return this.$textarea.scrollTop();
  },
  
  scrollTo: function(pos) {
    this.$textarea.scrollTop(pos);
  },
  
  scrollToEnd: function() {
    this.scrollTo(this.endScrollPos());
  },
  
  endScrollPos: function() {
    return this.$textarea[0].scrollHeight - this.$textarea.innerHeight();
  },
  
  isScrolledAway: function() {
    var scrollTop = this.getScrollTop(),
      scrollHeight = this.$textarea[0].scrollHeight,
      height = this.$textarea.innerHeight();
    
    return (scrollHeight - scrollTop) > Math.ceil(height);
  },
  
  handleScopeSelection: function(e) {
    var dataItem = this.scopeSelector.dataItem();
  
    this.clearTextArea();

    if (dataItem != null && dataItem.type == this.scopeSelector.SERVER) {
      var logInfo = this.getLogInfoForServer(dataItem.name);
    
      this.setStatus('Fetching log...');

      this.skipRefresh = true;
      this.fillExisting(dataItem.name);

      if (logInfo == null || logInfo.scrollPos == 0) {
        $.ajax({
          type: "GET",
          url: tmc.encodeURI(this.buildRequest(dataItem)),
          success: this.handleResponse,
          context: this,
          dataType: "json"
        }).error(function(jqXHR, textStatus, errorThrown) {
          if (textStatus != 'abort') {
            alert(textStatus);
          }
        }).always(function() {
          this.clearStatus();
        });
      } else {
        this.scrollTo(logInfo.scrollPos);
        this.clearStatus();
      }
    }
  },

  setStatus: function(msg) {
    this.$msgLabel.text(msg = (msg || ''));
    this.$body.css('cursor', (msg != '') ? 'wait' : 'default');
  },

  clearStatus: function() {
    this.setStatus();
  },
  
  fillExisting: function(serverName) {
    var logEntries = this.getLogEntriesForServer(serverName);

    if (logEntries != null && logEntries.length > 0) {
      var entries = [];
      
      $.each(logEntries, function(i, logEntry) {
        entries.push(logEntry.message);
      });
      
      this.$textarea.unbind(this.scrollEventHandlers);
      this.$textarea.text(entries.join(""));
      this.scrollToEnd();
      this.$textarea.bind(this.scrollEventHandlers);
    }
  },
  
  refresh: function() {
    if (this.$content.is(":visible") && this.skipRefresh == false) {
      var dataItem = this.scopeSelector.dataItem();

      if (dataItem != null && dataItem.type == this.scopeSelector.SERVER) {
        $.ajax({
          type: "GET",
          url: tmc.encodeURI(this.buildRequest(dataItem)),
          success: this.handleResponse,
          context: this,
          dataType: "json"
        }).error(function(jqXHR, textStatus, errorThrown) {
          if (textStatus != 'abort') {
            alert(textStatus);
          }
        }).always(function () {
          this.fireEvent("tmc.responseComplete");
        });
      } else {
        this.fireEvent("tmc.responseComplete");
      }
    } else {
      this.fireEvent("tmc.responseComplete");
    }
  }
});
