function AdminConfigPage(adminPage, $content) {
  TogglePageFragment.call(this, $content);
  
  this.adminPage = adminPage;

  var that = this;

  this.pages = {};
  this.pages.mainContent = new PageFragment(this.$content.find("div#mainContent"));
  this.pages.envContent = new PageFragment(this.$content.find("div#envContent"));
  this.pages.tcPropsContent = new PageFragment(this.$content.find("div#tcPropsContent"));
  this.pages.processArgsContent = new PageFragment(this.$content.find("div#processArgsContent"));
  this.pages.tcConfigContent = new PageFragment(this.$content.find("div#tcConfigContent"));
  
  this.$mainPanel = this.$content.find('div#mainContent');
  this.$envText = this.$content.find('div#envContent textarea');
  this.$tcPropsText = this.$content.find('div#tcPropsContent textarea');
  this.$processArgsText = this.$content.find('div#processArgsContent textarea');
  this.$tcConfigText = this.$content.find('div#tcConfigContent textarea');

  this.$content.find('textarea').bind({
    "scrollstart": function() {
      tmc.suspend();
    },
    "scrollstop": function() {
      tmc.resume();
    }
  });

  var $contentHolder = $content.find('#contentHolder');
  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight($contentHolder);
  });
  
  this.initialized = false;

  ClusterPageFragment.call(this, $content, {
    optionLabel: 'Select a cluster node...'
  });
}

AdminConfigPage.prototype = $.extend({}, TogglePageFragment.prototype, ClusterPageFragment.prototype, {
  getGroupPage: function() {
    return this.adminPage.getGroupPage();
  },

  testScopeSelection: function(e) {
    var kScopeSelector = this.scopeSelector.kScopeSelector,
      data = kScopeSelector.dataItem(e.item.index());
    
    if (data.type != this.scopeSelector.SERVER && data.type != this.scopeSelector.CLIENT) {
      e.preventDefault();
    }
  },

  show: function() {
    TogglePageFragment.prototype.show.call(this);
    
    if (this.initialized == false) {
      this.initialized = true;
      this.scopeSelector.handleOpening();
      this.handleScopeSelection();
    }
  },
  
  getConnectionGroup: function() {
    return this.adminPage.getConnectionGroup();
  },

  getClusterId: function() {
    return this.getConnectionGroup() + '_%_%_Connection#embedded';
  },
  
  displayMainPage: function() {
    this.displayNamedPage('main');
  },
  
  displayEnvironmentPage: function() {
    this.displayNamedPage('env');
  },
  
  displayTCPropertiesPage: function() {
    this.displayNamedPage('tcProps');
  },
  
  displayProcessArgumentsPage: function() {
    this.displayNamedPage('processArgs');
  },

  displayTCConfigPage: function() {
    this.displayNamedPage('tcConfig');
  },
  
  getTopology: function() {
    return tmc.getTopology(this.getConnectionGroup());
  },
  
  buildRequest: function(dataItem) {
    var that = this,
      id = this.adminPage.getClusterId(),
      command = "",
      suffix = "";
    
    switch (dataItem.type) {
      case 'server':
        command = '/servers';
        suffix = ';names=' + dataItem.name;
        break;
      case 'client':
        command = '/clients';
        suffix = ';ids=' + dataItem.clientID;
        break;
    }
    
    return "api/agents;ids=" + id + "/configurations" + command + suffix;
  },
  
  clearTable: function() {
    this.$mainPanel.find('table').children().remove();
  },
  
  populateMainPanel: function(dataItem) {
    var $table = this.$mainPanel.find('table'),
      connectionGroup = this.getConnectionGroup();
    
    switch (dataItem.type) {
      case 'server': {
        var server = tmc.getServerByName(connectionGroup, dataItem.name);
        this.populateTable($table, server.attributes);
        break;
      }
      case 'client': {
        var client = tmc.getClientByID(connectionGroup, dataItem.clientID);
        this.populateTable($table, client.attributes);
        break;
      }
    }
  },
  
  populateTable: function($table, attributes) {
    var keyList = $.map(attributes, function(v, k) {return k;});

    $table.empty();
    keyList.sort();

    $.each(keyList, function(i, key) {
      var value = attributes[key],
        rowStyle = '';
      
      if (key == 'ResourceState' && value != 'NORMAL') {
        rowStyle = "style='color:red;'";
      }
      $table.append('<tr ' + rowStyle + '><td style="text-align:right;">' + key + '</td><td>' + value + '</td></tr>');
    });
  },
  
  populateItems: function(dataItem, attributes) {
    this.populateMainPanel(dataItem);

    this.setText(this.$envText, attributes.environment);
    this.setText(this.$tcPropsText, attributes.tcProperties);
    this.setText(this.$processArgsText, attributes.processArguments != null ? attributes.processArguments.join('\n') : '');
    this.setText(this.$tcConfigText, attributes.config);
  },
  
  setText: function($textarea, content) {
    $textarea.text(content || '').scrollTop(0);
  },
  
  handleResponse: function(data) {
    if (data != null && data.length == 1) {
      this.populateItems(this.scopeSelector.dataItem(), data[0].attributes);
    }
  },
  
  isSelectable: function(type) {
    switch (type) {
      case this.scopeSelector.ALL_SERVERS:
      case this.scopeSelector.SERVER_GROUP:
      case this.scopeSelector.ALL_CLIENTS:
        return false;
    }
    return true;
  },
  
  handleScopeSelection: function(e) {
    var dataItem = this.scopeSelector.dataItem();
  
    this.clearTable();

    if (dataItem != null && this.isSelectable(dataItem.type)) {
      $.ajax({
        type: "GET",
        url: tmc.encodeURI(this.buildRequest(dataItem)),
        success: this.handleResponse,
        context: this,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != 'abort') {
          alert(textStatus);
        }
      }); 
    }
  },
  
  showServerDetails: function(serverName) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.select(function(dataItem) {
      return dataItem.name == serverName;
    });
    this.handleScopeSelection();
    this.displayNamedPage('main');
  },
  
  showServerConfig: function(serverName) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.select(function(dataItem) {
      return dataItem.name == serverName;
    });
    this.handleScopeSelection();
    this.displayNamedPage('tcConfig');
  },
  
  showClientDetails: function(remoteAddress) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.select(function(dataItem) {
      return dataItem.name == remoteAddress;
    });
    this.handleScopeSelection();
    this.displayNamedPage('main');
  },
  
  showClientConfig: function(remoteAddress) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.select(function(dataItem) {
      return dataItem.name == remoteAddress;
    });
    this.handleScopeSelection();
    this.displayNamedPage('tcConfig');
  },
  
  refresh: function() {
    if (this.$content.is(":visible") && this.getSelectedPage() == this.pages.mainContent) {
      var dataItem = this.scopeSelector.dataItem();

      if (dataItem != null && this.isSelectable(dataItem.type)) {
        this.populateMainPanel(dataItem);
      }
    }
    this.fireEvent("tmc.responseComplete");
  }
});
