function AdminBackupsPage(adminPage, $content) {
  PageFragment.call(this, $content);

  this.adminPage = adminPage;
  
  var that = this;
  
  this.kEntryTemplate = kendo.template(tmc.getTemplate("#clusterBackupStatusEntry").html());
  this.$button = $content.find('#makeBackup').click($.proxy(this.handleMakeBackup, this));
  this.kTableTemplate = kendo.template(tmc.getTemplate("#clusterBackupTable").html());

  this.$backupsContent = $content.find('div#backupsContent');
  this.$backupsContent.bind({
    "scrollstart": function() {
      tmc.suspend();
    },
    "scrollstop": function() {
      that.skipRefresh = (that.$backupsContent.scrollTop() != 0); 
      tmc.resume();
    }
  });

  this.skipRefresh = false;
}

AdminBackupsPage.prototype = $.extend({}, PageFragment.prototype, {
  getGroupPage: function() {
    return this.adminPage.getGroupPage();
  },

  getConnectionGroup: function() {
    return this.getGroupPage().getConnectionGroup();
  },
  
  testNotRestartable: function() {
    var topology = tmc.getTopology(this.getConnectionGroup()),
      result = false;
    
    if (topology != null) {
      $.each(topology.serverGroupEntities, function(i, serverGroup) {
        $.each(serverGroup.servers, function(j, server) {
          if (server.attributes.Restartable == false) {
            result = true;
            return false;
          }
        });
        if (result == true) {
          return false;
        }
      });
    }
    
    return result;
  },
  
  showExplaination: function() {
    this.$backupsContent.append(tmc.getTemplate('#notRestartableExplaination').html());
  },
  
  handleMakeBackup: function(e) {
    var that = this;
    
    this.$button.addClass('k-state-disabled');
    this.skipRefresh = true;

    if (this.testNotRestartable()) {
      this.showExplaination();
      return;
    }
    
    tmc.suspend();
    $.ajax({
      type: "POST",
      url: tmc.encodeURI(this.buildRequest()),
      dataType: "json",
      cancelable: false
    }).error(function(jqXHR, textStatus, errorThrown) {
      alert(textStatus);
    }).always(function() {
      that.skipRefresh = false;
      tmc.resume();
    });
  },
  
  buildRequest: function() {
    return 'api/agents;ids=' + this.adminPage.getClusterId() + '/backups';
  },
  
  handleResponse: function(data) {
    var that = this,
      anyRunning = false,
      nameMap = {}; /* name -> entryList */ 
    
    this.$backupsContent.empty();
    
    $.each(data, function(i, value) {
      var name = value.name;
      if (name != null && name.length > 0) {
        var entryList = nameMap[name];
        if (entryList == null) {
          nameMap[name] = entryList = [];
        }
        entryList.push(value);
      }
    });

    var nameList = $.map(nameMap, function(v, k) {return k;})
      .sort()
      .reverse();
    
    $.each(nameList, function(i, name) {
      var entryList = nameMap[name];

      entryList.sort(function(a, b) {
        if (a.sourceId < b.sourceId) {
          return -1;
        } else if (a.sourceId > b.sourceId) {
          return 1;
        }
        return 0;
      });
      
      var $table = $(that.kTableTemplate({})),
        $tbody = $table.find('tbody');

      $table.find('thead tr:first th').text(name);
      $.each(entryList, function(j, entry) {
        var stripe = tmc.getGroupForServer(that.getConnectionGroup(), entry.sourceId);
        entry.stripe = (stripe != null) ? stripe.name : "";
        $tbody.append(that.kEntryTemplate(entry));
        if (entry.status == 'RUNNING') {
          anyRunning = true;
        }
      });

      that.$backupsContent.append('&nbsp;');
      that.$backupsContent.append($table);
    });

    if (anyRunning == false) {
      that.$button.removeClass('k-state-disabled');
    }

    this.skipRefresh = false;
    this.fireEvent("tmc.responseComplete");
  },
  
  refresh: function() {
    if (this.$content.is(":visible") && this.skipRefresh == false) {
      this.skipRefresh = true;
      $.ajax({
        type: "GET",
        url: tmc.encodeURI(this.buildRequest()),
        success: this.handleResponse,
        context: this,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != 'abort') {
          alert(textStatus);
        }
      });
    } else {
      this.fireEvent("tmc.responseComplete");
    }
  }
});
