<%@page import="org.terracotta.management.ServiceLocator"%>
<%@ page import="com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener" %>
<%@ page import="com.terracotta.management.security.Authorizer" %>
<%@ page import="com.terracotta.management.user.UserRole" %>
<%@ page import="com.terracotta.management.services.SystemConfigService" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>Terracotta Management Console</title>
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-cache">
  <meta http-equiv="Expires" content="Sat, 01 Dec 2001 00:00:00 GMT">

  <link rel="shortcut icon" href="images/favicon.ico" />
  <link type="text/css" href="css/bootstrap.css" rel="stylesheet" />
  <link type="text/css" href="styles/kendo.common.min.css" rel="stylesheet" />
  <link type="text/css" href="styles/kendo.default.min.css" rel="stylesheet" />
  <link type="text/css" href="css/monitor.css" rel="stylesheet" />
  <script type="text/javascript" src="js/shim.js"></script>
  <script type="text/javascript" src="js/jquery.min.js"></script>
  <script type="text/javascript" src="js/jquery.ext.js"></script>  
  <script type="text/javascript" src="js/jquery.ba-resize.js"></script>  
  <script type="text/javascript" src="js/jquery.idle-timer.js"></script>  
  <script type="text/javascript" src="js/kendo.all.min.js"></script>
  <script type="text/javascript" src="js/kendo.data.ext.js"></script>
  <script type="text/javascript" src="js/kendo.grid.ext.js"></script>
  <script type="text/javascript" src="js/kendo.treeview.ext.js"></script>
  <script type="text/javascript" src="js/scroll-events.js"></script>
  <script type="text/javascript" src="js/json2.js"></script>
  <script type="text/javascript" src="js/vkbeautify.0.97.00.beta.js"></script>
  <script type="text/javascript" src="javascript/stdio.js"></script>
  <script type="text/javascript" src="javascript/about.js"></script>
  <script type="text/javascript" src="javascript/thin.format.js"></script>
  <script type="text/javascript" src="javascript/agent.config.js"></script>
  <script type="text/javascript" src="javascript/preference.manager.js"></script>
  <script type="text/javascript" src="javascript/connections.panel.js"></script>
  <script type="text/javascript" src="javascript/polling.panel.js"></script>
  <script type="text/javascript" src="javascript/security.panel.js"></script>

  <script type="text/javascript" src="javascript/cluster.scope.selector.js"></script>
  <script type="text/javascript" src="javascript/cluster.page.fragment.ui.js"></script>
  <script type="text/javascript" src="javascript/page.fragment.ui.js"></script>
  <script type="text/javascript" src="javascript/toggle.page.fragment.ui.js"></script>
  <script type="text/javascript" src="javascript/data.page.fragment.ui.js"></script>
  <script type="text/javascript" src="javascript/data.overview.ui.js"></script>
  <script type="text/javascript" src="javascript/data.charts.ui.js"></script>
  <script type="text/javascript" src="javascript/data.sizing.ui.js"></script>
  <script type="text/javascript" src="javascript/data.management.ui.js"></script>  
  <script type="text/javascript" src="javascript/data.page.ui.js"></script>
  <script type="text/javascript" src="javascript/monitoring.page.ui.js"></script>
  <script type="text/javascript" src="javascript/monitoring.stats.ui.js"></script>
  <script type="text/javascript" src="javascript/monitoring.events.ui.js"></script>
  <script type="text/javascript" src="javascript/administration.page.ui.js"></script>
  <script type="text/javascript" src="javascript/admin.config.ui.js"></script>
  <script type="text/javascript" src="javascript/admin.logs.ui.js"></script>
  <script type="text/javascript" src="javascript/admin.backups.ui.js"></script>
  <script type="text/javascript" src="javascript/admin.topology.ui.js"></script>
  <script type="text/javascript" src="javascript/troubleshooting.page.ui.js"></script>
  <script type="text/javascript" src="javascript/threaddumps.ui.js"></script>
  <script type="text/javascript" src="javascript/group.page.ui.js"></script>
  <script type="text/javascript" src="javascript/dashboard.ui.js"></script>
  <script type="text/javascript" src="javascript/cache.config.editor.js"></script>
  <script type="text/javascript" src="javascript/cachemanager.config.editor.js"></script>
  <script type="text/javascript" src="javascript/tmc.js"></script>
  <script type="text/javascript" src="javascript/banner.js"></script>

  <script type="text/javascript" src="js/bootstrap.min.js"></script>
  <script type="text/javascript" src="js/bootstrap-tooltip.min.js"></script>

  <script type="text/javascript">
    $(function() {
      var idleTimeoutMinutes = <%= pageContext.getServletContext().getInitParameter("idleTimeoutMinutes") %>,
        inAdminRole = <%= TMSEnvironmentLoaderListener.HAS_LICENSE == false || ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN) %>,
        user = "<%= ServiceLocator.locate(Authorizer.class).getPrincipal() %>",
        needMarketingManager = <%= !TMSEnvironmentLoaderListener.HAS_LICENSE || !TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE %>,
        contextPath = "${pageContext.request.contextPath}",
        options = {
          idleTimeoutMinutes: idleTimeoutMinutes,
          inAdminRole: inAdminRole,
          user: user,
          needMarketingManager: needMarketingManager,
          contextPath: contextPath
        };
              
      window.tmc = new tmc(options, $("#container"));

      $('div#dashboardToggle').click(function(e) {
        $('div#dashboardArea').toggle();
        $(e.target).find('b').toggleClass('icon-chevron-down icon-chevron-up');
        $('div#contentArea').trigger('resize');
      });
    });
  </script>
</head>

<body>

<div id="container" style="overflow:hidden;">
  <%-- only start ads if we do not have a real license --%>
  <% if (!TMSEnvironmentLoaderListener.HAS_LICENSE || !TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE ) { %>
  <div id="header">
    <div id="headerContent">
      <div id="tmcLogo"></div>
      <div id="adContent"></div>
    </div>
  </div>
  <% } else { %>
  <div id="headerLicensed">
    <div id="headerContentLicensed">
      <div id="tmcLogoLicensed"></div>
    </div>
  </div>
  <% } %>

  <div id="menu" class="gradient">
    <% if (TMSEnvironmentLoaderListener.HAS_LICENSE == false ||
        ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN)) { %>
    <a href="javascript:tmc.newConnection();" class="menuManage"><div class="menuItem" id="manageConnections">New Connection</div></a>
    <% } %>
    <a href="javascript:tmc.managePreferences();" class="menuSettings"><div class="menuItem" id="settings">Preferences</div></a>
    <a href="javascript:tmc.showAboutWindow();" class="menuAbout"><div class="menuItem" id="aboutMenuItem">About</div></a>
    <a href="tmc-help.html" target="_blank" class="menuHelp"><div class="menuItem">Help</div></a>
    <% if (TMSEnvironmentLoaderListener.HAS_LICENSE && ServiceLocator.locate(SystemConfigService.class).isAuthenticationEnabled()) { %>
    <a id="logout" href="${pageContext.request.contextPath}/logout"><div class="menuLogout">Logout</div></a>
    <% } %>
  </div>

  <div id="templates" style='display:none;'>
    <jsp:include page="templates.jsp" />
  </div>

  <div id="preference-manager">
    <jsp:include page="preference-manager.jsp" />
  </div>

  <div id="group-page">
    <jsp:include page="group-page.jsp" />
  </div>
  
  <jsp:include page="dashboard.jsp" />

  <div id='dashboardToggle' style='text-align:center;line-height:10px;background:lightGray;cursor:pointer;'>
    <a href='#' title='Toggle Dashboard'>
      <b class='icon-chevron-up'></b>
    </a>
  </div>
  
  <div id="top" style="display:none;">
    <ul>
      <li style="font-weight:bold;">Connection information for:&nbsp;</li>
      <li>
        <input id="connectionGroupSelector"/>
      </li>
    </ul>
    <a id='clusterStatus' href='#' style='display:none;' data-html='true' rel='tooltip'>
      <div class='k-block k-error-colored' style='color:black;font-weight:bold;'></div>
    </a>
  </div>
  <div id="contentArea"></div>

  <div id="about-dialog">
    <jsp:include page="about.jsp" />
  </div>
  
  <jsp:include page="stdio.jsp" />
</div>
</body>
</html>
