<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<div id="dashboardArea">
  <div id='template' class='well well-small' style='display:none;height:auto;'>
    <div class='noWrap dropdown'>
      <a id='header' href='#'></a>
      <span id='memberCount'></span>
      <a class='dropdown-toggle' data-toggle='dropdown' href='#' role='button' class='pull-right'>
        <b class='caret'></b>
      </a>
      <ul class='dropdown-menu pull-right' role='menu'>
        <li><a href='#' id='hide'>Hide This Connection</a></li>
        <li><a href='#' id='edit'>Edit This Connection</a></li>
        <li class='divider'></li>
        <li><a href='#' id='disconnect'>Delete</a></li>
      </ul>
      <a id='operatorEvents' href='#' style='display:none;' data-html='true' rel='tooltip' title='dynamically set'>
        <span class="badge badge-important">6</span>
      </a>
    </div>
    <span id='actives' class='label label-success noWrap'></span>
    <span id='mirrors' class='label label-info noWrap'></span>
    <br>
    <span id='starting' class='label label-warning noWrap'></span>
    <span id='initializing' class='label noWrap'></span>
    <span id='recovering' class='label label-recovering noWrap'></span>
    <span id='unreachable' class='label label-important noWrap'></span>
  </div>
  <div id='navigator' style='display:none;'>
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
      <h4 id="headerLabel"></h4>
    </div>
    <div class="modal-footer">
      <button id='appDataOverview' class="btn"><i class="icon-arrow-right"></i>App Data Overview</button>
      <button id='aggregateStats' class="btn"><i class="icon-arrow-right"></i>Aggregate Server Stats</button>
    </div>
    <div class="modal-body" style='overflow-y:auto'>
      <ul style='list-style-type:none;height:14em;'></ul>
    </div>
  </div>
  <table id='dashboard' cellspacing='1' cellpadding='1' border='0'>
    <tr></tr>
  </table>
  
  <script id='serverNavEntryTemplate' type='text/x-kendo-template'>
    # { var statusLabel = tmc.labelForState(data.State); #
      <li class='noWrap' style='list-style-type:none;'>
        #=data.Name#&nbsp;&nbsp;<a href='\\#' id='details'>#=data.Address#</a>&nbsp;&nbsp;
        [<a href='\\#' id='stats'>Stats</a>]&nbsp;&nbsp;[<a href='\\#' id='config'>Config</a>]&nbsp;&nbsp;
        <span style='text-align:right;'>#=statusLabel#</span>
      </li>
    # } #
  </script>
  
  <script id='clientNavEntryTemplate' type='text/x-kendo-template'>
    <li class='noWrap' style='list-style-type:none;'>
      <a href='\\#' id='details'>#=data.RemoteAddress#</a>&nbsp;&nbsp;ClientID[#=data.ClientID#]&nbsp;&nbsp;
      [<a href='\\#' id='stats'>Stats</a>]&nbsp;&nbsp;[<a href='\\#' id='config'>Config</a>]&nbsp;&nbsp;
    </li>
  </script>

  <script id='customNavEntryTemplate' type='text/x-kendo-template'>
    <li class='noWrap' style='list-style-type:none;'>
      <a href='\\#' id='details'>#=data.nodeName#</a>&nbsp;&nbsp;#=data.nodeAddress#&nbsp;&nbsp;
      [<a href='\\#' id='stats'>Stats</a>]&nbsp;&nbsp;[<a href='\\#' id='config'>Config</a>]&nbsp;&nbsp;
    </li>
  </script>

  <script id='customMembersTemplate' type='text/x-kendo-template'>
    # { var suffix = (data == 1) ? ' member' : ' members'; #
        (#=data# #=suffix#)
    # } #
  </script>

  <script id='clusterClientsTemplate' type='text/x-kendo-template'>
    # { var suffix = (data == 1) ? ' client' : ' clients'; #
        (#=data# #=suffix#)
    # } #
  </script>

  <script id='clusterActivesTemplate' type='text/x-kendo-template'>
    # { var suffix = (data == 1) ? ' Active' : ' Actives'; #
        #=data# #=suffix#
    # } #
  </script>

  <script id='clusterMirrorsTemplate' type='text/x-kendo-template'>
    # { var suffix = (data == 1) ? ' Mirror' : ' Mirrors'; #
        #=data# #=suffix#
    # } #
  </script>
  
  <script id="unreadOperatorEventsToolTipTemplate" type="text/x-kendo-template">
    <div>
      <h6>Unread Operator Events</h6>
      <table cellspacing='1' cellpadding='1' class='fullWidth'>
        <tr id='INFO'>
          <td style='text-align:right;width:50%;'>INFO</td>
          <td style='text-align:right;'>#=data.INFO#</td>
          <td style='width:20%;'></td>
        </tr>
        <tr id='WARN'>
          <td style='text-align:right;width:50%;'>WARN</td>
          <td style='text-align:right;'>#=data.WARN#</td>
          <td style='width:20%;'></td>
        </tr>
        <tr id='DEBUG'>
          <td style='text-align:right;width:50%;'>DEBUG</td>
          <td style='text-align:right;'>#=data.DEBUG#</td>
          <td style='width:20%;'></td>
        </tr>
        <tr id='ERROR'>
          <td style='text-align:right;width:50%;'>ERROR</td>
          <td style='text-align:right;'>#=data.ERROR#</td>
          <td style='width:20%;'></td>
        </tr>
        <tr id='CRITICAL'>
          <td style='text-align:right;width:50%;'>CRITICAL</td>
          <td style='text-align:right;'>#=data.CRITICAL#</td>
          <td style='width:20%;'></td>
        </tr>
      </table>
    </div>
  </script>
</div>


