<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<div id="connectionsPanel" class='box fullWidth fullHeight'>
  <div>
    <h3><a id='createConnection' href='#'>Create</a>, Edit, and Delete Connections and Connection Groups.</h3>
    <br>
    <p>Connections to Terracotta products, such as Ehcache, can be assigned to connection groups that you define.
       Connections groups can be useful for organizing sets of related connections, such as those in the same deployment
       environment.</p>
    <br>
    <a href='#' id='createConnection' class="menuManage"><div class="menuItem">Create New Connection</div></a>
    <br style='clear:both;'><br>
  </div>
  <form class='box' style='overflow-y:auto;'>
    <fieldset class='img-rounded'>
      <legend>Configured Connections</legend>
      <table cellspacing='1' cellpadding='3' border='0' class='fullWidth'>
      </table>
    </fieldset>
  </form>
</div>

<form id='template' style='display:none;'>
  <fieldset class='img-rounded'>
    <legend class='noWrap'>&nbsp;
      <small>
        <span id='header'></span>&nbsp;
        <a id='edit' href='#'>Edit</a>&nbsp;
        <a id='delete' href='#'>Delete</a>&nbsp;
      </small>  
    </legend>
    <div id='memberTemplate' style='text-align:left;padding:1px;'></div>
    <div id='showDetailsArea' class="k-block k-info-colored fullWidth" style='margin:1em 0em 0em 0em;'>
      <input id='showDetails' type='checkbox' checked class='noWrap'>Show in dashboard</input>
    </div>
  </fieldset>
</form>

<div id='connectionWizard' class='fullWidth fullHeight' style='display:none;display:table;'>
  <div id='location' class='fullWidth' style='display:table-cell;vertical-align:middle;'>
    <h3>Specify the location of the agent to be monitored</h3>
    <br>
    <table cellspacing='1' cellpadding='3' border='0' class='fullWidth' style="text-align:right;" >
      <tr>
        <td class='noWrap'>Connection Location (URL):</td>
        <td style="width: 300px;">
          <input id='agentLocation' type='text' size='60' value='http://localhost:9530'/>
          <img id="spinner" src="images/spinner.gif" title="Please wait while the TMC probes the connection" style="float:right; margin-top:3px; margin-right:3px; display: none" alt="Please wait while the TMC probes the connection"/>
        </td>
      </tr>
    </table>
    <div>
      <span style='float:right;'>
        <a id='cancel' href='#'>cancel</a>&nbsp;
        <button id='next' type='button' class='k-button'>Next</button>
      </span>
    </div>
  </div>
  
  <div id='customGroup' class='fullWidth' style='display:table-cell;vertical-align:middle;'>
    <h3>Create Connection to Ehcache CacheManager</h3>
    <br>
    <form>
      <table cellspacing='1' cellpadding='3' border='0' class='fullWidth'>
        <tr>
          <td id='existing'>
            <input type='radio' id='existing' name='radio' checked/>
            <label class='radio' for='existing'>
              Add to existing Connection Group:
            </label>
            <select id='groupSelector'></select>
          </td>
        </tr>
        <tr>
          <td id='new'>
            <input type='radio' name='radio' id='newGroup'/>
            <label class='radio' for='newGroup'>
              Create a new Connection Group for this Connection:
            </label>
            <input type='text' id='groupName' size='40' value='MyGroup' disabled/>
          </td>
        </tr>
      </table>
    </form>
    <div>
      <span style='float:right;'>
        <a id='cancel' href='#'>cancel</a>&nbsp;
        <a id='back' href='#'>back</a>&nbsp;
        <button id='next' type='button' class='k-button'>Next</button>
      </span>
    </div>
  </div>

  <div id='custom' class='fullWidth' style='display:table-cell;vertical-align:middle;'>
    <h3>Create Connection to Ehcache CacheManager</h3>
    <br>
    <table cellspacing='1' cellpadding='3' border='0' class='fullWidth'>
      <tr>
        <td style="text-align:right;" class='noWrap'>Connection Location:</td>
        <td id='location'></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Group:</td>
        <td id='group'></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Name:</td>
        <td><input id='name' type='text' size='50' value='MyConnection'/></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Connection Timeout:</td>
        <td><input id='connectionTimeout' type='number' min='0' value='5000'/></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Read Timeout:</td>
        <td><input id='readTimeout' type='number' min='0' value='5000'/></td>
      </tr>
    </table>
    <div>
      <span style='float:right;'>
        <a id='cancel' href='#'>cancel</a>&nbsp;
        <a id='back' href='#'>back</a>&nbsp;
        <button id='createConnection' type='button' class='k-button'>Create Connection</button>
      </span>
    </div>
  </div>

  <div id='cluster' class='fullWidth' style='display:table-cell;vertical-align:middle;'>
    <h3>Create Connection to Terracotta Server Array</h3>
    <br>
    <p>The location entered addresses the management interface of a Terracotta Server. The members of the Terracotta
       Server Array (TSA) to which the referred-to server belongs are listed below.</p>
    &nbsp;
    <div class="k-block k-info-colored">
      <p><span class="k-icon k-i-note"></span>These locations will be maintained automatically such that cluster management services are available to the
         greatest extent possible -- anything short of wholesale changes to the server topology should require no changes
         to this connection configuration.</p>
    </div>
    &nbsp;
    <table cellspacing='1' cellpadding='3' border='0' class='fullWidth' style='overflow-y:scroll;height:10em;border:solid 1px black;'>
    </table>
    &nbsp;
    <div>
      <span style='float:right;'>
        <a id='cancel' href='#'>cancel</a>&nbsp;
        <a id='back' href='#'>back</a>&nbsp;
        <button id='next' type='button' class='k-button'>Next</button>
      </span>
    </div>
  </div>

  <div id='clusterName' class='fullWidth' style='display:table-cell;vertical-align:middle;'>
    <h3>Specify a name for this clustered connection</h3>
    <br>
    <table cellspacing='1' cellpadding='3' border='0' class='fullWidth'>
      <tr>
        <td style="text-align:right;" class='noWrap'>Name:</td>
        <td><input id='name' type='text' size='50' value='MyCluster'/></td>
      </tr>
    </table>
    <div>
      <span style='float:right;'>
        <a id='cancel' href='#'>cancel</a>&nbsp;
        <a id='back' href='#'>back</a>&nbsp;
        <button id='createConnection' type='button' class='k-button'>Create Connection</button>
      </span>
    </div>
  </div>
  <div id='customEdit' class='fullWidth' style='display:none; display:table-cell;vertical-align:middle;'>
    <table cellspacing='1' cellpadding='3' border='0' class='fullWidth'>
      <tr>
        <td style="text-align:right;" class='noWrap'>Connection Location:</td>
        <td><input id='location' type='text' size='50' value='http://localhost:9888'/></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Group:</td>
        <td id='group'><select id='groupSelector'></select></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Name:</td>
        <td><input id='name' type='text' size='50' value='MyConnection'/></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Connection Timeout:</td>
        <td><input id='connectionTimeout' type='number' min='0' value='5000'/></td>
      </tr>
      <tr>
        <td style="text-align:right;" class='noWrap'>Read Timeout:</td>
        <td><input id='readTimeout' type='number' min='0' value='5000'/></td>
      </tr>
    </table>
    <div>
        <span style="margin-left: 305px;">
          <a id='cancel' href='#'>cancel</a>&nbsp;
          <button id='saveChanges' type='button' class='k-button'>Save changes</button>
        </span>
    </div>
  </div>
</div>
