/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.userprofile.resource.services;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

@Path(value="/userprofiles")
public final class UserProfileResourceService {
    private final UserProfileDao usrProfileDao = (UserProfileDao)ServiceLocator.locate(UserProfileDao.class);
    private final Authorizer authorizer = (Authorizer)ServiceLocator.locate(Authorizer.class);

    @GET
    @Path(value="/{userid}")
    @Produces(value={"text/xml"})
    public String retrieveProfile(@PathParam(value="userid") String userid) {
        this.checkAuthorization(userid);
        return this.usrProfileDao.getById(userid);
    }

    @POST
    @Consumes(value={"text/xml"})
    public void addUserProfile(String userId, String userProfile) {
        this.checkAuthorization(userId);
        try {
            this.usrProfileDao.create(userId, userProfile);
        }
        catch (DataAccessException e) {
            throw new ResourceRuntimeException("Error adding user profile", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @PUT
    @Path(value="/{userid}")
    @Consumes(value={"text/xml"})
    public void updateUserProfile(@PathParam(value="userid") String userid, String userProfile) {
        this.checkAuthorization(userid);
        try {
            this.usrProfileDao.createOrUpdate(userid, userProfile);
        }
        catch (DataAccessException e) {
            throw new ResourceRuntimeException("Error updating user profile", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @DELETE
    @Path(value="/{userid}")
    public void deleteUserProfile(@PathParam(value="userid") String userid) {
        this.checkAuthorization(userid);
        try {
            this.usrProfileDao.delete(userid);
        }
        catch (DataAccessException e) {
            throw new ResourceRuntimeException("Error deleting user profile", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private void checkAuthorization(String userId) {
        if (!this.authorizer.isUserInRole(UserRole.ADMIN) && !this.authorizer.getPrincipal().equals(userId)) {
            throw new ResourceRuntimeException("Missing role " + UserRole.ADMIN + " or tried to spoof user " + userId, Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }
}

