/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.userprofile.dao.impl;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.dao.impl.XMLFileUserProfileDao;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XMLFileUserProfileDao
implements UserProfileDao {
    private static final Logger LOG = LoggerFactory.getLogger(XMLFileUserProfileDao.class);
    public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + "/.tc/mgmt";
    private ConcurrentHashMap<String, String> profilesMap = new ConcurrentHashMap();
    private File tmcUserClientPreferencesDirectory;

    public XMLFileUserProfileDao() {
        File[] listFiles;
        String tmcConfigurationDirectory = System.getProperty("com.tc.management.config.directory") == null ? TMC_CONFIGURATION_DEFAULT_DIRECTORY : System.getProperty("com.tc.management.config.directory");
        this.tmcUserClientPreferencesDirectory = new File(tmcConfigurationDirectory + "/client/");
        if (!this.tmcUserClientPreferencesDirectory.exists()) {
            this.tmcUserClientPreferencesDirectory.mkdirs();
        }
        1 filesEndingWithDotXmlFilter = new /* Unavailable Anonymous Inner Class!! */;
        for (File file : listFiles = this.tmcUserClientPreferencesDirectory.listFiles((FilenameFilter)filesEndingWithDotXmlFilter)) {
            this.loadConfig(file.getName().substring(0, file.getName().indexOf(".xml")));
        }
    }

    private String loadConfig(String username) {
        File configFile = new File(this.tmcUserClientPreferencesDirectory, username + ".xml");
        String lConfig = null;
        try {
            lConfig = this.loadConfigFromFile(configFile);
        }
        catch (IOException e) {
            LOG.error("could not create and load user profile client preferences file in " + configFile, (Throwable)e);
        }
        this.profilesMap.put(username, lConfig);
        return lConfig;
    }

    String loadConfigFromFile(File src) throws IOException {
        if (src.exists()) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(src);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failure loading configuration file: " + src.getAbsolutePath(), e);
            }
            return this.loadConfigFromInputStream((InputStream)fis);
        }
        return null;
    }

    String loadConfigFromInputStream(InputStream src) {
        return UserProfileSettings.access$000((InputStream)src);
    }

    public String getById(String userId) {
        return (String)this.profilesMap.get(userId);
    }

    public void create(String userId, String userProfile) throws DataAccessException {
        String up = this.profilesMap.putIfAbsent(userId, userProfile);
        if (up != null) {
            throw new DataAccessException(String.format("Failed to create user profile '%s' because it already exists.", userProfile));
        }
        this.persistUserProfile(userId, userProfile);
    }

    private void persistUserProfile(String userId, String userProfile) throws DataAccessException {
        try {
            UserProfileSettings.access$100((String)userProfile, (File)new File(this.tmcUserClientPreferencesDirectory, userId + ".xml"));
        }
        catch (FileNotFoundException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void createOrUpdate(String userId, String userProfile) throws DataAccessException {
        this.profilesMap.put(userId, userProfile);
        this.persistUserProfile(userId, userProfile);
    }

    public void delete(String userId) throws DataAccessException {
        String up = (String)this.profilesMap.remove(userId);
        if (up == null) {
            throw new DataAccessException(String.format("Failed to delete user profile '%s' because it does not exist.", userId));
        }
        this.deleteUserProfile(userId);
    }

    private void deleteUserProfile(String userId) throws DataAccessException {
        File file = new File(this.tmcUserClientPreferencesDirectory, userId + ".xml");
        if (!file.delete()) {
            throw new DataAccessException("Could not delete user preference file :" + file.getAbsolutePath());
        }
    }
}

