/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import com.terracotta.license.LicenseManager;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.SystemConfigService;
import com.terracotta.management.user.UserRole;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.terracotta.license.LicenseException;
import org.terracotta.management.ServiceLocator;

public final class SetupAwareFilter
implements Filter {
    private static final String TMC_HOME = "/index.jsp";
    private static final String TMC_AUTHENTICATION = "/setup/authenticationSetup.jsp";
    private static final String TMC_RESTART = "/restart.jsp";
    private static final String TMC_LOGOUT_URL = "/logout.jsp";
    private final SecurityContextManager securityCtxtMgr = (SecurityContextManager)ServiceLocator.locate(SecurityContextManager.class);
    private boolean restartNeeded;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.restartNeeded = false;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (req.getRequestURI().startsWith(req.getContextPath() + "/images/") || req.getRequestURI().startsWith(req.getContextPath() + "/css/") || req.getRequestURI().startsWith(req.getContextPath() + "/javascript/") || req.getRequestURI().startsWith(req.getContextPath() + "/js/") || req.getRequestURI().startsWith(req.getContextPath() + "/json/") || req.getRequestURI().startsWith(req.getContextPath() + "/styles/") || req.getRequestURI().startsWith(req.getContextPath() + "/tcinfo.html") || req.getRequestURI().startsWith(req.getContextPath() + "/tcAd")) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            boolean authenticationEnabled = ((SystemConfigService)ServiceLocator.locate(SystemConfigService.class)).isAuthenticationEnabled();
            boolean firstRun = ((SystemConfigService)ServiceLocator.locate(SystemConfigService.class)).isFirstRun();
            boolean isUserConsideredAnAdmin = ((Authorizer)ServiceLocator.locate(Authorizer.class)).isUserInRole(UserRole.ADMIN) || !authenticationEnabled;
            ServletContext servletContext = req.getSession().getServletContext();
            if (req.getRequestURI().startsWith(req.getContextPath() + TMC_RESTART)) {
                this.restartNeeded = true;
            }
            if (this.restartNeeded) {
                if (!req.getRequestURI().startsWith(req.getContextPath() + TMC_RESTART)) {
                    RequestDispatcher rd = servletContext.getRequestDispatcher(TMC_RESTART);
                    rd.forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
                return;
            }
            if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && firstRun) {
                if (req.getRequestURI().startsWith(req.getContextPath() + TMC_AUTHENTICATION) || req.getRequestURI().startsWith(req.getContextPath() + "/setup")) {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                } else {
                    RequestDispatcher rd = servletContext.getRequestDispatcher(TMC_AUTHENTICATION);
                    rd.forward((ServletRequest)req, (ServletResponse)resp);
                }
            } else if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && !firstRun && authenticationEnabled) {
                boolean ctxtValid = this.securityCtxtMgr.hasValidSecurityContext();
                if (!ctxtValid) {
                    if (req.getRequestURI().startsWith(req.getContextPath() + "/setup/accountSetup.jsp") || req.getRequestURI().startsWith(req.getContextPath() + "/setup")) {
                        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                    } else {
                        RequestDispatcher rd = servletContext.getRequestDispatcher("/setup/accountSetup.jsp");
                        rd.forward((ServletRequest)req, (ServletResponse)resp);
                    }
                } else if (!isUserConsideredAnAdmin && req.getRequestURI().startsWith(req.getContextPath() + "/setup")) {
                    resp.sendError(401);
                } else {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
            } else if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && !authenticationEnabled && this.tmcNeedsToRestart(Boolean.valueOf(authenticationEnabled))) {
                if (req.getRequestURI().startsWith(req.getContextPath() + TMC_RESTART)) {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                } else {
                    RequestDispatcher rd = servletContext.getRequestDispatcher(TMC_RESTART);
                    rd.forward((ServletRequest)req, (ServletResponse)resp);
                }
            } else {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    public void destroy() {
    }

    private boolean tmcNeedsToRestart(Boolean authenticationEnabled) {
        return authenticationEnabled != false && this.securityCtxtMgr == null || this.securityCtxtMgr != null && authenticationEnabled == false;
    }

    static {
        if (TMSEnvironmentLoaderListener.HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                TMSEnvironmentLoaderListener.HAS_LICENSE = true;
                TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE = LicenseManager.isCommercialLicense();
            }
            catch (LicenseException e) {
                TMSEnvironmentLoaderListener.HAS_LICENSE = false;
            }
        }
    }
}

