/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import com.terracotta.management.services.SystemConfigService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.Utils;

public final class ConfigureTmsTrustStoreServlet
extends HttpServlet {
    public static final String TMC_HOME_URL = "/";
    public static final String TMC_RESTART_URL = "/restart.jsp";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureTmsTrustStoreServlet.class);
    private final SystemConfigService systemConfigService = (SystemConfigService)ServiceLocator.locate(SystemConfigService.class);
    private static final String USE_TMS_TRUSTSTORE = "useTmsTruststore";
    private static final String USE_TMS_TRUSTSTORE_HIDDEN = "useTmsTruststoreHidden";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String useTmsTrustStoreString = req.getParameter(USE_TMS_TRUSTSTORE);
        String useTmsTrustStoreHiddenField = req.getParameter(USE_TMS_TRUSTSTORE_HIDDEN);
        if (Utils.trimToNull((String)useTmsTrustStoreHiddenField) == null) {
            LOG.debug("useTmsTrustStore was null");
            resp.sendError(500, "The form was not submitted properly");
        } else {
            boolean tmsTrustStore;
            boolean bl = tmsTrustStore = useTmsTrustStoreString != null && useTmsTrustStoreString.equals("on");
            if (tmsTrustStore == this.systemConfigService.isTmsTruststoreUsedForHttpsAgents()) {
                resp.sendRedirect(req.getContextPath() + TMC_HOME_URL);
            } else {
                try {
                    this.systemConfigService.setAndSaveTmsTrustoreUsedForHttpsAgents(tmsTrustStore);
                    resp.sendRedirect(req.getContextPath() + TMC_RESTART_URL);
                }
                catch (ServiceExecutionException e) {
                    LOG.debug("Could not save configuration", (Throwable)e);
                    resp.sendError(500, "the configuration could not be saved");
                }
            }
        }
    }
}

