/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import com.terracotta.management.security.shiro.configuration.ShiroConfigurationGenerator;
import com.terracotta.management.security.shiro.realm.LdapConfigurationChecker;
import com.terracotta.management.security.shiro.realm.LdapConfigurationException;
import com.terracotta.management.services.SystemConfigService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.Utils;

public final class ConfigureAuthServlet
extends HttpServlet {
    private static final String NONE = "NONE";
    private static final String INI = "INI";
    private static final String LDAP = "LDAP";
    private static final String AD = "AD";
    public static final String AUTHENTICATION_TYPE = "AUTHENTICATION_TYPE";
    public static final String SOME_FIELDS_ARE_EMPTY = "SOME_FIELDS_ARE_EMPTY";
    public static final String DISPLAY_LDAP_SETUP = "DISPLAY_LDAP_SETUP";
    public static final String DISPLAY_AD_SETUP = "DISPLAY_AD_SETUP";
    public static final String TMC_SETUP_URL = "/setup/accountSetup.jsp";
    public static final String TMC_RESTART_URL = "/restart.jsp";
    private static final String TMC_AUTHENTICATION = "/setup/authenticationSetup.jsp";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureAuthServlet.class);
    private static final String ERR_MSG = "Some fields are empty, please check you provided the needed information!";
    private static final String OPERATOR_GROUP = "operatorGroup";
    private static final String ADMIN_GROUP = "adminGroup";
    private static final String USER_DN_TEMPLATE = "userDnTemplate";
    private static final String SEARCH_BASE = "searchBase";
    private static final String URL = "url";
    private static final String SYSTEM_USERNAME = "systemUsername";
    private static final String DYNAMIC_GROUP_CONFIGURATION = "dynamicGroupConfiguration";
    private static final String GROUP_ATTRIBUTE_MATCHING = "groupAttributeMatching";
    public static final String GROUP_DN_TEMPLATE = "groupDnTemplate";
    private final SystemConfigService systemConfigService = (SystemConfigService)ServiceLocator.locate(SystemConfigService.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher(TMC_AUTHENTICATION);
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String authenticationType = req.getParameter(AUTHENTICATION_TYPE);
        if (Utils.trimToNull((String)authenticationType) == null) {
            resp.sendRedirect(req.getContextPath() + TMC_SETUP_URL);
        } else if (authenticationType.equals(AD) || authenticationType.equals(LDAP)) {
            String operatorGroupsAsString = Utils.trimToNull((String)req.getParameter(OPERATOR_GROUP));
            Set operatorGroups = this.getGroups(operatorGroupsAsString);
            String adminGroupsAsString = Utils.trimToNull((String)req.getParameter(ADMIN_GROUP));
            Set adminGroups = this.getGroups(adminGroupsAsString);
            String searchBase = Utils.trimToNull((String)req.getParameter(SEARCH_BASE));
            String url = Utils.trimToNull((String)req.getParameter(URL));
            String systemUsername = Utils.trimToNull((String)req.getParameter(SYSTEM_USERNAME));
            String userDnTemplate = Utils.trimToNull((String)req.getParameter(USER_DN_TEMPLATE));
            String groupDnTemplate = Utils.trimToNull((String)req.getParameter(GROUP_DN_TEMPLATE));
            String dynamicGroupConfiguration = Utils.trimToNull((String)req.getParameter(DYNAMIC_GROUP_CONFIGURATION));
            String groupAttributeMatching = Utils.trimToNull((String)req.getParameter(GROUP_ATTRIBUTE_MATCHING));
            req.setAttribute(OPERATOR_GROUP, (Object)operatorGroupsAsString);
            req.setAttribute(ADMIN_GROUP, (Object)adminGroupsAsString);
            req.setAttribute(SEARCH_BASE, (Object)searchBase);
            req.setAttribute(URL, (Object)url);
            req.setAttribute(SYSTEM_USERNAME, (Object)systemUsername);
            req.setAttribute(USER_DN_TEMPLATE, (Object)userDnTemplate);
            req.setAttribute(GROUP_DN_TEMPLATE, (Object)groupDnTemplate);
            req.setAttribute(DYNAMIC_GROUP_CONFIGURATION, (Object)dynamicGroupConfiguration);
            req.setAttribute(GROUP_ATTRIBUTE_MATCHING, (Object)groupAttributeMatching);
            if (operatorGroups.isEmpty() || adminGroups.isEmpty() || this.isOneOfThemEmpty(new String[]{searchBase, url}) && (authenticationType.equals(AD) || authenticationType.equals(LDAP) && this.isOneOfThemEmpty(new String[]{userDnTemplate, groupDnTemplate, groupAttributeMatching}))) {
                this.wrapErrorIntoRequest(req, resp, ERR_MSG, authenticationType.equals(LDAP));
                return;
            }
            req.removeAttribute(SOME_FIELDS_ARE_EMPTY);
            try {
                LdapConfigurationChecker.connectAndCheckConfiguration((String)url, (String)searchBase, (String)systemUsername, (Set)operatorGroups, (Set)adminGroups, (String)userDnTemplate, (String)groupDnTemplate, (String)groupAttributeMatching, (!Boolean.parseBoolean(dynamicGroupConfiguration) ? 1 : 0) != 0);
            }
            catch (LdapConfigurationException e) {
                String errorMessage = e.getMessage() + (e.getCause() != null && e.getCause().getMessage() != null ? "<br />Details : " + e.getCause().getMessage() : "");
                this.wrapErrorIntoRequest(req, resp, errorMessage, authenticationType.equals(LDAP));
                return;
            }
            if (authenticationType.equals(AD)) {
                try {
                    ShiroConfigurationGenerator.writeShiroConfigurationActiveDirectory((Set)operatorGroups, (Set)adminGroups, (String)searchBase, (String)url, (String)systemUsername);
                    this.systemConfigService.setAuthenticationEnabled(true);
                }
                catch (Exception e) {
                    LOG.error("Failed to setup active directory configuration!", (Throwable)e);
                }
            } else {
                try {
                    ShiroConfigurationGenerator.writeShiroConfigurationLdap((Set)operatorGroups, (Set)adminGroups, (String)userDnTemplate, (String)groupDnTemplate, (String)searchBase, (String)url, (String)systemUsername, (boolean)Boolean.parseBoolean(dynamicGroupConfiguration), (String)groupAttributeMatching);
                    this.systemConfigService.setAuthenticationEnabled(true);
                }
                catch (Exception e) {
                    LOG.error("Failed to setup ldap configuration!", (Throwable)e);
                }
            }
        } else if (authenticationType.equals(INI)) {
            try {
                ShiroConfigurationGenerator.writeShiroConfigurationIniFile();
                this.systemConfigService.setAuthenticationEnabled(true);
            }
            catch (Exception e) {
                LOG.error("Failed to setup shiro ini configuration!", (Throwable)e);
            }
        } else if (authenticationType.equals(NONE)) {
            try {
                this.systemConfigService.setAuthenticationEnabled(false);
            }
            catch (ServiceExecutionException e) {
                LOG.error("Failed to disable authentication!", (Throwable)e);
            }
        }
        resp.sendRedirect(req.getContextPath() + TMC_RESTART_URL);
    }

    private Set<String> getGroups(String groupsAsString) {
        String[] splitGroups = groupsAsString.split(",");
        HashSet<String> groups = new HashSet<String>();
        for (String group : splitGroups) {
            String trimmedGroup = Utils.trimToNull((String)group);
            if (trimmedGroup == null) continue;
            groups.add(trimmedGroup);
        }
        return groups;
    }

    private void wrapErrorIntoRequest(HttpServletRequest req, HttpServletResponse resp, String errorMessage, boolean isLdap) throws ServletException, IOException {
        req.setAttribute(SOME_FIELDS_ARE_EMPTY, (Object)errorMessage);
        if (isLdap) {
            req.setAttribute(DISPLAY_LDAP_SETUP, (Object)true);
        } else {
            req.setAttribute(DISPLAY_AD_SETUP, (Object)true);
        }
        RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher(TMC_AUTHENTICATION);
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }

    private boolean isOneOfThemEmpty(String ... parameters) {
        for (String parameter : parameters) {
            if (parameter != null) continue;
            return true;
        }
        return false;
    }
}

