/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.terracotta.management.AgentsUtils;
import com.terracotta.management.AggregateCallback;
import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.config.Agent;
import com.terracotta.management.resource.BackupEntity;
import com.terracotta.management.resource.ClientEntity;
import com.terracotta.management.resource.ConfigEntity;
import com.terracotta.management.resource.LogEntity;
import com.terracotta.management.resource.OperatorEventEntity;
import com.terracotta.management.resource.ProbeEntity;
import com.terracotta.management.resource.StatisticsEntity;
import com.terracotta.management.resource.ThreadDumpEntity;
import com.terracotta.management.resource.TopologyEntity;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.JerseyClientFactory;
import com.terracotta.management.services.ResourceServiceClientService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.Representable;
import org.terracotta.management.resource.VersionedEntity;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JerseyResourceServiceClientService
implements ResourceServiceClientService,
Observer {
    private static final String HTTPS_SCHEME = "https://";
    private static final String URI_CTXT_SEP = "/";
    private static final Logger LOG = LoggerFactory.getLogger(JerseyResourceServiceClientService.class);
    private final ConfigService configSvc;
    private final JerseyClientFactory clientFactory;
    private final Authorizer authorizer;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Client>> clientsByUsernameAndId;

    public JerseyResourceServiceClientService(ConfigService configSvc, JerseyClientFactory clientFactory, Authorizer authorizer) {
        this.configSvc = configSvc;
        this.clientFactory = clientFactory;
        this.authorizer = authorizer;
        Collection knownAgents = configSvc.getAgents();
        ConcurrentHashMap<String, ConcurrentHashMap> clientsByUsernameAndId = new ConcurrentHashMap<String, ConcurrentHashMap>();
        for (Agent a : knownAgents) {
            ConcurrentHashMap clientsByIds = clientsByUsernameAndId.get(a.getUsername()) == null ? new ConcurrentHashMap() : (ConcurrentHashMap)clientsByUsernameAndId.get(a.getUsername());
            clientsByIds.put(a.getId(), this.prepareClient(a));
            clientsByUsernameAndId.put(a.getUsername(), clientsByIds);
        }
        this.clientsByUsernameAndId = clientsByUsernameAndId;
        this.configSvc.registerObserver((Observer)this);
    }

    public void addClient(Agent a) {
        a.setUsername(this.authorizer.getPrincipal());
        ConcurrentHashMap clientsByIds = this.clientsByUsernameAndId.get(a.getUsername()) == null ? new ConcurrentHashMap() : (ConcurrentHashMap)this.clientsByUsernameAndId.get(a.getUsername());
        clientsByIds.put(a.getId(), this.prepareClient(a));
        this.clientsByUsernameAndId.put(a.getUsername(), clientsByIds);
    }

    public Set<String> getKnownAgentIds() {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        return Collections.unmodifiableSet(this.hideProbeAgentFromTheClient((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())));
    }

    private void checkCurrentUserHasValidConfigAndLoadItOtherwise() {
        if (this.clientsByUsernameAndId.get(this.authorizer.getPrincipal()) == null) {
            try {
                this.configSvc.saveConfig(this.authorizer.getPrincipal());
            }
            catch (ServiceExecutionException e) {
                LOG.error("Impossible to load user defaults settings", (Throwable)e);
            }
        }
    }

    public <RESOURCE extends VersionedEntity> void proxyGet(AggregateCallback<RESOURCE> callback, URI request, String[] agentIds, Class<RESOURCE> entityClass) {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        HashMap<String, Future> futures = new HashMap<String, Future>(((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).size());
        List<String> ids = agentIds == null ? ((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).keySet() : Arrays.asList(agentIds);
        for (String string : ids) {
            Future asyncCalc;
            String[] idParts = string.split("\\#");
            Client client = (Client)((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).get(idParts[0]);
            if (client == null) continue;
            String realAgentId = idParts.length > 1 ? idParts[1] : null;
            URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request, (String)realAgentId);
            AsyncWebResource resource = client.asyncResource(location);
            try {
                asyncCalc = resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(entityClass);
            }
            catch (UniformInterfaceException e) {
                LOG.warn("Failure setting up async computation.", (Throwable)e);
                continue;
            }
            futures.put(string, asyncCalc);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                VersionedEntity entity = (VersionedEntity)((Future)entry.getValue()).get();
                String[] idParts = ((String)entry.getKey()).split("\\#");
                entity.setAgentId(idParts[0] + "#" + entity.getAgentId());
                callback.addResponse((Representable)entity);
            }
            catch (InterruptedException e) {
                LOG.warn("Future interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                this.logAgentExecutionException(e);
                callback.addException((Exception)e);
            }
        }
    }

    public <RESOURCE extends Representable> void proxyGet(AggregateCollectionCallback<RESOURCE> callback, URI request, String[] agentIds, Class<RESOURCE> entityClass) {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        ConcurrentHashMap clientsById = (ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal());
        if (clientsById == null) {
            return;
        }
        HashMap<String, Future> futures = new HashMap<String, Future>(clientsById.size());
        Collection<String> ids = agentIds == null ? this.hideProbeAgentFromTheClient(clientsById) : Arrays.asList(agentIds);
        for (String id : ids) {
            Future asyncCalc;
            String[] idParts = id.split("\\#");
            Client client = (Client)clientsById.get(idParts[0]);
            if (client == null) continue;
            String realAgentId = idParts.length > 1 ? idParts[1] : null;
            URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request, (String)realAgentId);
            AsyncWebResource resource = client.asyncResource(location);
            try {
                asyncCalc = resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(JerseyResourceServiceClientService.buildGenericType(entityClass));
            }
            catch (UniformInterfaceException e) {
                LOG.warn("Failure setting up async computation.", (Throwable)e);
                continue;
            }
            futures.put(id, asyncCalc);
        }
        String currentAgentId = "";
        for (Map.Entry entry : futures.entrySet()) {
            try {
                currentAgentId = (String)entry.getKey();
                Collection entities = (Collection)((Future)entry.getValue()).get();
                for (Representable entity : entities) {
                    String[] idParts = ((String)entry.getKey()).split("\\#");
                    entity.setAgentId(idParts[0] + "#" + entity.getAgentId());
                }
                callback.addResponses(entities);
            }
            catch (InterruptedException e) {
                LOG.warn("Future interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                Agent agent;
                if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof ConnectException && (agent = this.configSvc.getAgent(currentAgentId, this.authorizer.getPrincipal())) != null && agent.getType() == Agent.TYPE.TSA && agent.getAgentsLocations().size() > 1) {
                    String agentLocation = this.rotateAgentLocationUrls(agent);
                    agent.setAgentLocation(agentLocation);
                    Client prepareClient = this.prepareClient(agent);
                    clientsById.put(currentAgentId, prepareClient);
                    LOG.debug("Using now " + (String)agent.getAgentsLocations().get(0) + " as agent url for " + currentAgentId);
                }
                this.logAgentExecutionException(e);
                callback.addException((Exception)e);
            }
        }
    }

    private Set<String> hideProbeAgentFromTheClient(ConcurrentHashMap<String, Client> clientsById) {
        HashSet<String> ids = new HashSet<String>(clientsById.keySet());
        ids.remove("probeGroup_%_%_probeClient#embedded");
        ids.remove("probeGroup_%_%_probeClient");
        return ids;
    }

    protected String rotateAgentLocationUrls(Agent agent) {
        ArrayList agentsLocations = new ArrayList(agent.getAgentsLocations());
        Collections.rotate(agentsLocations, -1);
        String agentLocation = "";
        boolean first = true;
        for (String string : agentsLocations) {
            if (first) {
                agentLocation = string;
                first = false;
                continue;
            }
            agentLocation = agentLocation + "," + string;
        }
        return agentLocation;
    }

    public void proxyDelete(URI request, String agentId) {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        String[] agentParts = agentId.split("\\#");
        Client client = (Client)((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).get(agentParts[0]);
        if (client != null) {
            String realAgentId = agentParts.length > 1 ? agentParts[1] : null;
            WebResource resource = client.resource(JerseyResourceServiceClientService.buildURI((Client)client, (URI)request, (String)realAgentId));
            try {
                resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).delete();
            }
            catch (UniformInterfaceException e) {
                throw new WebApplicationException(e.getCause(), Response.status((int)e.getResponse().getStatus()).entity(e.getResponse().getEntity(String.class)).type((String)e.getResponse().getHeaders().getFirst((Object)"Content-Type")).build());
            }
        } else {
            throw new ResourceRuntimeException("No such connection: " + agentParts[0], Response.Status.GONE.getStatusCode());
        }
    }

    public <RESOURCE> void proxyPut(URI request, RESOURCE entity, String agentId) {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        String[] agentParts = agentId.split("\\#");
        Client client = (Client)((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).get(agentParts[0]);
        if (client != null) {
            String realAgentId = agentParts.length > 1 ? agentParts[1] : null;
            WebResource resource = client.resource(JerseyResourceServiceClientService.buildURI((Client)client, (URI)request, (String)realAgentId));
            try {
                ((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE).header("tc-identity-token", (Object)this.authorizer.getSessionId())).put(entity);
            }
            catch (UniformInterfaceException e) {
                throw new WebApplicationException(e.getCause(), Response.status((int)e.getResponse().getStatus()).entity(e.getResponse().getEntity(String.class)).type((String)e.getResponse().getHeaders().getFirst((Object)"Content-Type")).build());
            }
        } else {
            throw new ResourceRuntimeException("No such connection: " + agentParts[0], Response.Status.GONE.getStatusCode());
        }
    }

    public <RESOURCE> Response proxyPost(URI request, RESOURCE entity, String agentId) {
        this.checkCurrentUserHasValidConfigAndLoadItOtherwise();
        String[] agentParts = agentId.split("\\#");
        Client client = (Client)((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).get(agentParts[0]);
        if (client != null) {
            try {
                String realAgentId = agentParts.length > 1 ? agentParts[1] : null;
                URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request, (String)realAgentId);
                WebResource resource = client.resource(location);
                Object postResult = ((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE).header("tc-identity-token", (Object)this.authorizer.getSessionId())).post(Object.class, entity);
                return Response.created((URI)location).entity(postResult).build();
            }
            catch (UniformInterfaceException e) {
                throw new WebApplicationException(e.getCause(), Response.status((int)e.getResponse().getStatus()).entity(e.getResponse().getEntity(String.class)).type((String)e.getResponse().getHeaders().getFirst((Object)"Content-Type")).build());
            }
        }
        throw new ResourceRuntimeException("No such connection: " + agentParts[0], Response.Status.GONE.getStatusCode());
    }

    @Override
    public void update(Observable o, Object id) {
        String agentId = (String)String.class.cast(id);
        Agent agent = this.configSvc.getAgent(agentId, this.authorizer.getPrincipal());
        if (this.clientsByUsernameAndId.get(this.authorizer.getPrincipal()) == null) {
            ConcurrentHashMap clientsByIds = new ConcurrentHashMap();
            this.clientsByUsernameAndId.put(this.authorizer.getPrincipal(), clientsByIds);
        }
        if (agent == null) {
            ((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).remove(agentId);
        } else {
            URI checkClientURI;
            Client current = (Client)((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).get(agentId);
            Client newClient = this.prepareClient(agent);
            try {
                checkClientURI = new URI("agents/info");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("BUG Alert! Invalid agent info URI.", e);
            }
            URI checkLocation = JerseyResourceServiceClientService.buildURI((Client)newClient, (URI)checkClientURI, null);
            WebResource resource = newClient.resource(checkLocation);
            try {
                AgentMetadataEntity ame;
                Collection ames = (Collection)resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(JerseyResourceServiceClientService.buildGenericType(AgentMetadataEntity.class));
                if (!ames.isEmpty() && agent.update(ame = (AgentMetadataEntity)ames.iterator().next())) {
                    newClient = this.prepareClient(agent);
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (current != null) {
                ((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).replace(agentId, current, newClient);
            } else {
                ((ConcurrentHashMap)this.clientsByUsernameAndId.get(this.authorizer.getPrincipal())).putIfAbsent(agentId, newClient);
            }
        }
    }

    private void logAgentExecutionException(ExecutionException e) {
        String extraErrorMessage = "";
        if (e.getCause() instanceof UniformInterfaceException) {
            UniformInterfaceException cause = (UniformInterfaceException)e.getCause();
            StringBuilder sb = new StringBuilder();
            sb.append(System.getProperty("line.separator")).append("HTTP(S) response was:");
            sb.append(System.getProperty("line.separator")).append("Status: ").append(cause.getResponse().getStatus());
            sb.append(System.getProperty("line.separator")).append("Content type: ").append((String)cause.getResponse().getHeaders().getFirst((Object)"Content-Type"));
            sb.append(System.getProperty("line.separator")).append("Body:");
            sb.append(System.getProperty("line.separator"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(cause.getResponse().getEntityInputStream()));
            try {
                while (true) {
                    String line;
                    if ((line = bufferedReader.readLine()) == null) {
                        extraErrorMessage = sb.toString();
                        break;
                    }
                    sb.append(line).append(System.getProperty("line.separator"));
                }
            }
            catch (IOException ioe) {
                LOG.warn("Unable ro read response", (Throwable)ioe);
            }
            try {
                cause.getResponse().getEntityInputStream().reset();
            }
            catch (IOException ioe) {
                LOG.warn("Unable ro reset response", (Throwable)ioe);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.warn("Failed to execute request against monitorable entity. " + extraErrorMessage, (Throwable)e);
        } else {
            LOG.warn("Failed to execute request against monitorable entity. " + extraErrorMessage, (Object)e.getMessage());
        }
    }

    private static URI buildURI(Client client, URI request, String agentId) {
        URI baseUri = (URI)client.getProperties().get("CLIENT_BASE_URI");
        if (baseUri == null) {
            throw new RuntimeException("Bug Alert! Invalid aggregator configuration: missing client base URI.");
        }
        String requestPath = request.getPath();
        int idx = requestPath.indexOf("/");
        String endPath = idx > -1 ? requestPath.substring(idx + 1, requestPath.length()) : "";
        UriBuilder builder = UriBuilder.fromUri((URI)baseUri).path("agents");
        if (agentId != null) {
            builder = builder.matrixParam("ids", new Object[]{agentId});
        }
        builder.path(endPath);
        String query = request.getQuery();
        if (query != null) {
            builder.replaceQuery(query);
        }
        return builder.build(new Object[0]);
    }

    private Client prepareClient(Agent a) {
        URI clientBase;
        Integer rto;
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Integer cto = a.getConnectionTimeoutMillis();
        if (cto != null) {
            clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", cto);
        }
        if ((rto = a.getReadTimeoutMillis()) != null) {
            clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", rto);
        }
        try {
            clientBase = JerseyResourceServiceClientService.extractBaseURI((Agent)a);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("BUG Alert! Failed to extract valid URI from agent while setting up client. ");
        }
        clientConfig.getProperties().put("CLIENT_BASE_URI", clientBase);
        clientConfig.getProperties().put("CLIENT_CERT_AUTH_ENABLED", clientBase.toString().startsWith("https://") ? a.isClientAuthEnabled() : false);
        clientConfig.getProperties().put("SECURITY_ENABLED", a.isSecured());
        return this.clientFactory.createClient((ClientConfig)clientConfig);
    }

    private static URI extractBaseURI(Agent agent) throws URISyntaxException {
        URL agentURL;
        try {
            agentURL = agent.getType().equals((Object)Agent.TYPE.TSA) ? new URL(AgentsUtils.checkTsaAgentLocationsAndReturnFirstValidOne((Agent)agent)) : new URL(agent.getAgentLocation());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("BUG Alert! Failed to retrieve agent location URL while setting up client.");
        }
        String path = agentURL.getPath();
        if (!path.matches(".*/tc-management-api/$")) {
            path = path + "/tc-management-api/";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        return new URI(agentURL.getProtocol() + "://" + agentURL.getAuthority() + path);
    }

    private static GenericType buildGenericType(Class<? extends Representable> clazz) {
        if (clazz == AgentEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == AgentMetadataEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheManagerEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheStatisticSampleEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == ProbeEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == TopologyEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == StatisticsEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == ClientEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == ConfigEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == ThreadDumpEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == BackupEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == LogEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == OperatorEventEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        throw new UnsupportedOperationException(String.format("Unknown entity class \"%s\" for GenericType construction.", clazz.getCanonicalName()));
    }
}

