/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.terracotta.management.config.SystemConfig;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.SystemConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;

public class FileSystemConfigService
implements SystemConfigService {
    private static final String IS_FIRST_RUN = "firstRun";
    private static final String AUTHENTICATION_ENABLED = "authenticationEnabled";
    private static final String USE_TMS_TRUST_STORE_FOR_HTTPS_AGENTS = "useTmsTrustStoreForHttpsAgents";
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemConfigService.class);
    public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + System.getProperty("file.separator") + ".tc" + System.getProperty("file.separator") + "mgmt" + System.getProperty("file.separator");
    private final File systemConfigFile;
    private final SystemConfig systemConfig = new SystemConfig();
    private final Properties defaultProps;

    public FileSystemConfigService() {
        this.systemConfigFile = new File(System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "settings.ini");
        this.defaultProps = new Properties();
        if (!this.systemConfigFile.exists()) {
            this.systemConfigFile.getParentFile().mkdirs();
            try {
                this.saveSystemConfigFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Impossible to initialize the system settings persistence file, set to " + this.systemConfigFile.getAbsolutePath(), e);
            }
        }
        try {
            this.loadSystemConfigFromFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible to interact the system settings persistence file, set to " + this.systemConfigFile.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSystemConfigFromFile() throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.systemConfigFile);
            this.defaultProps.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.systemConfig.setAuthenticationEnabled(Boolean.parseBoolean(this.defaultProps.getProperty(AUTHENTICATION_ENABLED)));
        this.systemConfig.setUseTmsTrustore(Boolean.parseBoolean(this.defaultProps.getProperty(USE_TMS_TRUST_STORE_FOR_HTTPS_AGENTS)));
        this.systemConfig.setFirstRun(Boolean.parseBoolean(this.defaultProps.getProperty(IS_FIRST_RUN)));
    }

    public synchronized boolean isFirstRun() {
        return this.systemConfig.isFirstRun();
    }

    public boolean storesAndKeychainExist() {
        File tmsKeyStore = new File(System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-keystore");
        File tmsTrustStore = new File(System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-truststore");
        File keychain = new File(System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "keychain");
        return tmsKeyStore.exists() && tmsTrustStore.exists() && keychain.exists();
    }

    public String getTmcConfigurationDirectory() {
        return System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY);
    }

    public synchronized boolean isAuthenticationEnabled() {
        return TMSEnvironmentLoaderListener.HAS_LICENSE != false && this.systemConfig.isAuthenticationEnabled();
    }

    public boolean isTmsTruststoreUsedForHttpsAgents() {
        return this.systemConfig.isUseTmsTruststore();
    }

    public synchronized void setAuthenticationEnabled(boolean authenticationEnabled) throws ServiceExecutionException {
        if (this.systemConfig.isFirstRun() && this.storesAndKeychainExist()) {
            this.systemConfig.setUseTmsTrustore(true);
        }
        this.systemConfig.setAuthenticationEnabled(authenticationEnabled);
        this.systemConfig.setFirstRun(false);
        try {
            this.saveSystemConfigFile();
        }
        catch (IOException e) {
            LOG.error("Impossible to persist system settings to settings.xml", (Throwable)e);
            throw new ServiceExecutionException((Throwable)e);
        }
    }

    public void setAndSaveTmsTrustoreUsedForHttpsAgents(boolean useTmsTrustore) throws ServiceExecutionException {
        this.systemConfig.setUseTmsTrustore(useTmsTrustore);
        try {
            this.saveSystemConfigFile();
        }
        catch (IOException e) {
            LOG.error("Impossible to persist system settings to settings.xml", (Throwable)e);
            throw new ServiceExecutionException((Throwable)e);
        }
    }

    private void saveSystemConfigFile() throws IOException {
        this.defaultProps.put(IS_FIRST_RUN, Boolean.toString(this.systemConfig.isFirstRun()));
        this.defaultProps.put(AUTHENTICATION_ENABLED, Boolean.toString(this.systemConfig.isAuthenticationEnabled()));
        this.defaultProps.put(USE_TMS_TRUST_STORE_FOR_HTTPS_AGENTS, Boolean.toString(this.systemConfig.isUseTmsTruststore()));
        FileOutputStream out = new FileOutputStream(this.systemConfigFile);
        this.defaultProps.store(out, "TMC system settings");
        out.close();
    }
}

