/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.terracotta.management.config.Agent;
import com.terracotta.management.config.Config;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.impl.FileConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;

public final class FileConfigService
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigService.class);
    private static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + "/.tc/mgmt";
    private static String TMC_CONFIGURATION_DIRECTORY = System.getProperty("com.tc.management.config.directory") == null ? TMC_CONFIGURATION_DEFAULT_DIRECTORY : System.getProperty("com.tc.management.config.directory");
    private static File TMC_USER_SERVER_PREFERENCES_DIRECTORY = new File(TMC_CONFIGURATION_DIRECTORY + "/server/");
    private final Map<String, Config> configs = new HashMap();
    private Observer observer;

    public FileConfigService() {
        File[] listFiles;
        1 filesEndingWithDotXmlFilter = new /* Unavailable Anonymous Inner Class!! */;
        for (File file : listFiles = TMC_USER_SERVER_PREFERENCES_DIRECTORY.listFiles((FilenameFilter)filesEndingWithDotXmlFilter)) {
            this.loadConfig(file.getName().substring(0, file.getName().indexOf(".xml")));
        }
    }

    void createConfigFromTemplate(String tmpltConfigFileName, File cfgFile, String username) {
        LOG.info("Config file does not exists.  Creating one from template: " + tmpltConfigFileName);
        try {
            this.copyConfigFileFromClassPathResource(tmpltConfigFileName, cfgFile, username);
        }
        catch (IOException e) {
            LOG.warn("Failed to copy template config.", (Throwable)e);
        }
    }

    public Agent getAgent(String agentId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.getAgent(agentId);
    }

    public Collection<Agent> getAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (Map.Entry configEntry : this.configs.entrySet()) {
            Set groups = ((Config)configEntry.getValue()).getGroups();
            for (String group : groups) {
                Collection agentsByGroup = ((Config)configEntry.getValue()).getAgentsByGroup(group);
                agents.addAll(agentsByGroup);
            }
        }
        return agents;
    }

    public Collection<Agent> getAgentsByGroup(String groupId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.getAgentsByGroup(groupId);
    }

    private Config loadConfig(String username) {
        File configFile = new File(TMC_USER_SERVER_PREFERENCES_DIRECTORY, username + ".xml");
        if (!configFile.exists()) {
            String templateConfigFileName = System.getProperty("com.tc.management.config.tmplt", "templateConfig.xml");
            this.createConfigFromTemplate(templateConfigFileName, configFile, username);
        }
        Config lConfig = null;
        try {
            lConfig = this.loadConfigFromFile(configFile, username);
        }
        catch (IOException e) {
            LOG.warn("Config file not found.  Creating empty one.");
        }
        Config config = lConfig == null ? new Config(username) : lConfig;
        this.configs.put(username, config);
        if (this.observer != null) {
            config.addObserver(this.observer);
        }
        for (String group : config.getGroups()) {
            for (Agent agent : config.getAgentsByGroup(group)) {
                config.agentsChanged(agent.getId());
            }
        }
        return config;
    }

    public Collection<String> getGroups(String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.getGroups();
    }

    public boolean addGroup(String groupId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.addGroup(groupId);
    }

    public boolean deleteGroup(String groupId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.deleteGroup(groupId);
    }

    public boolean renameGroup(String oldGroupId, String newGroupId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.renameGroup(oldGroupId, newGroupId);
    }

    public void deleteAgent(String agentId, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        config.deleteAgent(agentId);
    }

    public boolean addAgent(Agent agent, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.addAgent(agent);
    }

    public boolean updateAgent(String agentId, Agent agent, String username) {
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        return config.updateAgent(agentId, agent);
    }

    public boolean saveConfig(String username) throws ServiceExecutionException {
        boolean success = false;
        Config config = this.configs.get(username) != null ? (Config)this.configs.get(username) : this.loadConfig(username);
        File configFile = new File(TMC_USER_SERVER_PREFERENCES_DIRECTORY, username + ".xml");
        try {
            this.storeConfigInFile(config, configFile, username);
        }
        catch (IOException e) {
            throw new ServiceExecutionException("Failed to save config file.", (Throwable)e);
        }
        catch (JAXBException e) {
            throw new ServiceExecutionException("Failed to serialize config.", (Throwable)e);
        }
        return success;
    }

    public void registerObserver(Observer observer) {
        this.observer = observer;
        for (Map.Entry configEntry : this.configs.entrySet()) {
            ((Config)configEntry.getValue()).addObserver(observer);
        }
    }

    void storeConfigInFile(Config cfg, File cfgFile, String username) throws IOException, JAXBException {
        boolean existingConfig = cfgFile.exists();
        File backFile = new File(cfgFile.getAbsolutePath() + "_tmp" + System.currentTimeMillis());
        if (existingConfig) {
            LOG.debug("Backing up config to: '" + backFile.getAbsolutePath() + "'");
            this.copyConfigFile(cfgFile, backFile, username);
            if (!cfgFile.delete()) {
                throw new IOException("Unable to delete existing configFile '" + cfgFile + "'");
            }
        } else if (!cfgFile.getParentFile().exists() && !cfgFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create path '" + cfgFile.getParentFile() + "'");
        }
        LOG.info("Writing config to: '" + cfgFile.getAbsolutePath() + "'");
        Config.write((Config)cfg, (File)cfgFile);
        if (existingConfig) {
            LOG.debug("Removing back up config: '" + backFile.getAbsolutePath() + "'");
            if (!backFile.delete()) {
                throw new IOException("Unable to delete backup file '" + backFile + "'");
            }
        }
    }

    Config loadConfigFromFile(File src, String username) throws IOException {
        if (src.exists()) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(src);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failure loading configuration file: " + src.getAbsolutePath(), e);
            }
            return this.loadConfigFromInputStream((InputStream)fis, username);
        }
        return null;
    }

    Config loadConfigFromInputStream(InputStream src, String username) throws IOException {
        try {
            Config config = Config.load((InputStream)src, (String)username);
            return config;
        }
        catch (JAXBException e) {
            throw new IOException("Failure loading configuration input stream.", e);
        }
        finally {
            try {
                src.close();
            }
            catch (IOException e1) {
                LOG.warn("Failed to close config file input stream.", (Throwable)e1);
            }
        }
    }

    private void copyConfigFile(File sourceFile, File destFile, String username) throws IOException {
        if (!sourceFile.exists()) {
            throw new IOException("Source file for copy " + sourceFile.getAbsolutePath() + " does not exist.");
        }
        try {
            Config tmpltConfig = this.loadConfigFromFile(sourceFile, username);
            this.storeConfigInFile(tmpltConfig, destFile, username);
        }
        catch (JAXBException e) {
            throw new IOException("Error serializing template config", e);
        }
    }

    private void copyConfigFileFromClassPathResource(String resourceName, File destFile, String username) throws IOException {
        InputStream src = FileConfigService.class.getClassLoader().getResourceAsStream(resourceName);
        try {
            Config tmpltConfig = this.loadConfigFromInputStream(src, username);
            this.storeConfigInFile(tmpltConfig, destFile, username);
        }
        catch (JAXBException e) {
            throw new IOException("Error serializing template config", e);
        }
    }

    static {
        if (!TMC_USER_SERVER_PREFERENCES_DIRECTORY.exists()) {
            TMC_USER_SERVER_PREFERENCES_DIRECTORY.mkdirs();
        }
    }
}

