/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.services.JerseyClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public final class DfltJerseyClientFactory
implements JerseyClientFactory {
    private final ClientFilter clientFilter;
    private final SSLContextFactory sslCtxtFactory;

    public DfltJerseyClientFactory(ClientFilter clientFilter, SSLContextFactory sslCtxtFactory) {
        this.clientFilter = clientFilter;
        this.sslCtxtFactory = sslCtxtFactory;
    }

    public Client createClient(ClientConfig clientConfig) {
        URI baseURI = (URI)clientConfig.getProperties().get("CLIENT_BASE_URI");
        if (this.sslCtxtFactory != null && baseURI.getScheme().equalsIgnoreCase("https")) {
            SSLContext sslCtxt;
            try {
                sslCtxt = this.sslCtxtFactory.create();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to invalid KeyManagerFactory algorithm.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to inability to load keyStore.", e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to invalid KeyStore type.", e);
            }
            catch (CertificateException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to invalid certificates in a KeyStore.", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to bad key in a KeyStore.", e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to one or more invalid keys in a KeyStore.", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failure instantiating TMS Jersey client due to bad store location.", e);
            }
            HostnameVerifier hostnameVerifier = Boolean.getBoolean("tc.ssl.disableHostnameVerifier") ? new /* Unavailable Anonymous Inner Class!! */ : HttpsURLConnection.getDefaultHostnameVerifier();
            clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hostnameVerifier, sslCtxt));
        }
        Client c = Client.create((ClientConfig)clientConfig);
        c.addFilter(this.clientFilter);
        return c;
    }
}

