/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.shiro;

import java.io.File;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMSIniWebEnvironment
extends IniWebEnvironment {
    private static final Logger log = LoggerFactory.getLogger(TMSIniWebEnvironment.class);
    public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + System.getProperty("file.separator") + ".tc" + System.getProperty("file.separator") + "mgmt" + System.getProperty("file.separator");
    private static final String CONFIG_LOCATION = new String(System.getProperty("com.tc.management.config.directory", TMC_CONFIGURATION_DEFAULT_DIRECTORY)) + "shiro.ini";
    private static final String GLOBAL_SETTINGS_CONFIG_LOCATION = new String(System.getProperty("com.tc.management.config.directory", TMC_CONFIGURATION_DEFAULT_DIRECTORY)) + "settings.ini";

    public void init() {
        log.info("Using customed TMS shiro.ini file at : " + CONFIG_LOCATION);
        Ini ini = null;
        try {
            ini = this.createIni("file://" + CONFIG_LOCATION, true);
        }
        catch (ConfigurationException e) {
            log.error(CONFIG_LOCATION + " does noes exist; you have to restart and configure TMC global configuration");
            File globalConfigFile = new File(GLOBAL_SETTINGS_CONFIG_LOCATION);
            globalConfigFile.delete();
            throw e;
        }
        this.setIni(ini);
        this.configure();
    }
}

