/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.shiro;

import com.sun.jersey.api.client.filter.ClientFilter;
import com.terracotta.license.LicenseManager;
import com.terracotta.management.UpdateChecker;
import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.resource.services.validator.impl.AggregateEhcacheRequestValidator;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.impl.DefaultSSLContextFactory;
import com.terracotta.management.security.impl.DfltRequestTicketMonitor;
import com.terracotta.management.security.impl.NoSecurityContextAuthorizer;
import com.terracotta.management.security.impl.SecretFileStoreKeyChainAccessor;
import com.terracotta.management.security.impl.TMCStoresSSLContextFactory;
import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.security.services.impl.IniFileSetupService;
import com.terracotta.management.security.shiro.ShiroAuthorizer;
import com.terracotta.management.security.shiro.ShiroSecurityContextManager;
import com.terracotta.management.security.shiro.realm.TCIniRealm;
import com.terracotta.management.security.web.impl.LicensedIdentityAsserter;
import com.terracotta.management.security.web.impl.NoOpIdentityAsserter;
import com.terracotta.management.security.web.jersey.TMSRequestClientFilter;
import com.terracotta.management.security.web.jersey.TMSRequestSecurityClientFilter;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.JerseyClientFactory;
import com.terracotta.management.services.ResourceServiceClientService;
import com.terracotta.management.services.SystemConfigService;
import com.terracotta.management.services.impl.DfltJerseyClientFactory;
import com.terracotta.management.services.impl.FileConfigService;
import com.terracotta.management.services.impl.FileSystemConfigService;
import com.terracotta.management.services.impl.JerseyResourceServiceClientService;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.dao.impl.IniFileUserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfoFactory;
import com.terracotta.management.user.services.UserService;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.dao.impl.XMLFileUserProfileDao;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.LicenseException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.validator.RequestValidator;

public final class TMSEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    private static final long EVERY_WEEK = 604800000L;
    private static final long DELAY_UPDATE_CHECK = 1000L;
    public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + System.getProperty("file.separator") + ".tc" + System.getProperty("file.separator") + "mgmt" + System.getProperty("file.separator");
    public static Boolean TMS_IS_SECURED = false;
    public static Boolean HAS_LICENSE;
    public static Boolean LICENSE_IS_COMMERCIAL_LICENSE;
    private static final Logger LOG;
    private Timer updateCheckTimer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        LOG.info("Entering TMSEnvironmentLoaderListener.contextInitialized()");
        this.checkLicense();
        FileSystemConfigService systemConfigService = new FileSystemConfigService();
        DfltUserInfoFactory usrInfoFactory = new DfltUserInfoFactory();
        XMLFileUserProfileDao usrProfileDao = new XMLFileUserProfileDao();
        this.loadContextAccordingToLicenseAndAuth(servletContextEvent, (SystemConfigService)systemConfigService, (UserInfoFactory)usrInfoFactory, (UserProfileDao)usrProfileDao);
        this.scheduleUpdateCheckIfNeeded();
    }

    void loadContextAccordingToLicenseAndAuth(ServletContextEvent servletContextEvent, SystemConfigService systemConfigService, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao) {
        if (HAS_LICENSE.booleanValue() && systemConfigService.isAuthenticationEnabled()) {
            TMS_IS_SECURED = true;
            LOG.info("TMS license properly loaded, and authentication is enabled : TMS is secured");
            this.initEnvironment(servletContextEvent.getServletContext());
            this.loadLicensedCtxt(systemConfigService, usrInfoFactory, usrProfileDao, servletContextEvent.getServletContext());
        } else {
            LOG.info("TMS is NOT secured  : no license found or no authentication enabled, or either");
            this.loadUnlicensedCtxt(systemConfigService, usrInfoFactory, usrProfileDao);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (HAS_LICENSE.booleanValue()) {
            this.destroyEnvironment(servletContextEvent.getServletContext());
        }
        ServiceLocator.unload();
        if (this.updateCheckTimer != null) {
            this.updateCheckTimer.cancel();
        }
    }

    private void checkLicense() {
        if (HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                HAS_LICENSE = true;
                LICENSE_IS_COMMERCIAL_LICENSE = LicenseManager.isCommercialLicense();
            }
            catch (LicenseException e) {
                HAS_LICENSE = false;
            }
        }
    }

    private void loadLicensedCtxt(SystemConfigService fileSystemConfigService, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao, ServletContext sc) {
        DefaultSSLContextFactory sslCtxtFactory;
        SecretFileStoreKeyChainAccessor keyChainAccessor;
        ShiroAuthorizer authorizer = new ShiroAuthorizer();
        DfltRequestTicketMonitor monitor = new DfltRequestTicketMonitor();
        try {
            keyChainAccessor = new SecretFileStoreKeyChainAccessor();
        }
        catch (KeychainInitializationException e) {
            throw new RuntimeException("Failure instantiating a licensed TMS (security enabled) due to invalid keychain configuration.", e);
        }
        if (fileSystemConfigService.storesAndKeychainExist() && fileSystemConfigService.isTmsTruststoreUsedForHttpsAgents()) {
            LOG.info("SSL configuration with keystore and truststore found, registering a custom sslContextFactory using them");
            sslCtxtFactory = new TMCStoresSSLContextFactory((KeyChainAccessor)keyChainAccessor, System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-keystore", System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-truststore");
        } else {
            LOG.info("The system property useTmsTrustStoreForHttpsAgents found in settings.ini is set to false or either one of the tms-truststore, the tms-keystore or the keychain were not found in " + System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + ", the TMC will use the default JDK truststore when connecting to HTTPS agents");
            sslCtxtFactory = new DefaultSSLContextFactory();
        }
        TMSRequestSecurityClientFilter clientFilter = new TMSRequestSecurityClientFilter((RequestTicketMonitor)monitor, (KeyChainAccessor)keyChainAccessor);
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)clientFilter, (SSLContextFactory)sslCtxtFactory);
        FileConfigService configSvc = new FileConfigService();
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService((ConfigService)configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        ServiceLocator locator = new ServiceLocator();
        try {
            TCIniRealm realm = (TCIniRealm)this.initializeRealm(sc);
            ShiroSecurityContextManager secCtxtMgr = new ShiroSecurityContextManager(new IniFileUserInfoDao(), realm);
            IniFileSetupService secCtxtSetupSvc = new IniFileSetupService((UserService)secCtxtMgr, usrInfoFactory);
            LicensedIdentityAsserter idAsserter = new LicensedIdentityAsserter((Authorizer)authorizer, (RequestTicketMonitor)monitor, (UserService)secCtxtMgr, (KeyChainAccessor)keyChainAccessor);
            locator.loadService(RequestIdentityAsserter.class, (Object)idAsserter);
            locator.loadService(SecurityContextManager.class, (Object)secCtxtMgr);
            locator.loadService(RequestIdentityAsserter.class, (Object)idAsserter);
            locator.loadService(SecurityContextSetupService.class, (Object)secCtxtSetupSvc);
        }
        catch (DataAccessException e) {
            throw new RuntimeException("Failure instantiating TMS context because user info datasource could not be found or initialized.", e);
        }
        catch (ClassCastException e) {
            LOG.debug("The user has configured an Ldap Realm");
            1 secCtxtMgr = new /* Unavailable Anonymous Inner Class!! */;
            locator.loadService(SecurityContextManager.class, (Object)secCtxtMgr);
        }
        AggregateEhcacheRequestValidator requestValidator = new AggregateEhcacheRequestValidator((Authorizer)authorizer);
        locator.loadService(RequestValidator.class, (Object)requestValidator).loadService(ConfigService.class, (Object)configSvc).loadService(ResourceServiceClientService.class, (Object)rsrcSvcClientSvc).loadService(UserProfileDao.class, (Object)usrProfileDao).loadService(Authorizer.class, (Object)authorizer).loadService(KeyChainAccessor.class, (Object)keyChainAccessor).loadService(SystemConfigService.class, (Object)fileSystemConfigService);
        ServiceLocator.load((ServiceLocator)locator);
    }

    private void loadUnlicensedCtxt(SystemConfigService fileSystemConfigService, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao) {
        NoSecurityContextAuthorizer authorizer = new NoSecurityContextAuthorizer();
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)new TMSRequestClientFilter(), null);
        FileConfigService configSvc = new FileConfigService();
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService((ConfigService)configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        NoOpIdentityAsserter idAsserter = new NoOpIdentityAsserter(usrInfoFactory);
        AggregateEhcacheRequestValidator requestValidator = new AggregateEhcacheRequestValidator((Authorizer)authorizer);
        ServiceLocator locator = new ServiceLocator().loadService(RequestValidator.class, (Object)requestValidator).loadService(ConfigService.class, (Object)configSvc).loadService(ResourceServiceClientService.class, (Object)rsrcSvcClientSvc).loadService(UserProfileDao.class, (Object)usrProfileDao).loadService(Authorizer.class, (Object)authorizer).loadService(SystemConfigService.class, (Object)fileSystemConfigService).loadService(RequestIdentityAsserter.class, (Object)idAsserter);
        ServiceLocator.load((ServiceLocator)locator);
    }

    private AuthorizingRealm initializeRealm(ServletContext sc) {
        TCIniRealm realm = null;
        WebEnvironment env = (WebEnvironment)sc.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        Collection realms = ((RealmSecurityManager)env.getWebSecurityManager()).getRealms();
        for (Realm r : realms) {
            if (r instanceof TCIniRealm) {
                realm = (TCIniRealm)r;
                continue;
            }
            if (!(r instanceof JndiLdapRealm)) continue;
            realm = (JndiLdapRealm)r;
            break;
        }
        if (realm == null) {
            throw new RuntimeException("Failure instantiating TMS context. Failure to find expected security realm.");
        }
        return realm;
    }

    private void scheduleUpdateCheckIfNeeded() {
        if (!Boolean.getBoolean("com.terracotta.management.skipUpdateCheck")) {
            this.updateCheckTimer = new Timer(true);
            this.updateCheckTimer.scheduleAtFixedRate((TimerTask)new UpdateChecker(HAS_LICENSE.booleanValue()), 1000L, 604800000L);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TMSEnvironmentLoaderListener.class);
    }
}

