/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.web.filter;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class TCBasicWithFormFallbackAuthenticationFilter
extends FormAuthenticationFilter {
    private boolean isBasicAuth;
    private static final String AUTHORIZATION_HEADER = "Authorization";

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isBasicLoginAttempt(request, response)) {
            this.isBasicAuth = true;
            if (!this.executeLogin(request, response)) {
                HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
                httpResponse.setStatus(401);
                return false;
            }
            return true;
        }
        this.isBasicAuth = false;
        return super.onAccessDenied(request, response);
    }

    private boolean isBasicLoginAttempt(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String authzHeader = httpRequest.getHeader(AUTHORIZATION_HEADER);
        return authzHeader != null && authzHeader.toLowerCase().startsWith("basic");
    }

    protected boolean sendChallenge(ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        httpResponse.setStatus(401);
        return false;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        if (this.isBasicAuth) {
            return true;
        }
        return super.onLoginSuccess(token, subject, request, response);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (this.isBasicAuth) {
            return false;
        }
        return super.onLoginFailure(token, e, request, response);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        if (this.isBasicAuth) {
            HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
            String authorizationHeader = httpRequest.getHeader(AUTHORIZATION_HEADER);
            if (authorizationHeader == null || authorizationHeader.length() == 0) {
                return this.createToken("", "", request, response);
            }
            String[] prinCred = this.getPrincipalsAndCredentials(authorizationHeader, request);
            if (prinCred == null || prinCred.length < 2) {
                String username = prinCred == null || prinCred.length == 0 ? "" : prinCred[0];
                return this.createToken(username, "", request, response);
            }
            String username = prinCred[0];
            String password = prinCred[1];
            return this.createToken(username, password, request, response);
        }
        return super.createToken(request, response);
    }

    private String[] getPrincipalsAndCredentials(String authorizationHeader, ServletRequest request) {
        if (authorizationHeader == null) {
            return null;
        }
        String[] authTokens = authorizationHeader.split(" ");
        if (authTokens == null || authTokens.length < 2) {
            return null;
        }
        String decoded = Base64.decodeToString((String)authTokens[1]);
        return decoded.split(":", 2);
    }
}

