/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.impl.SecretFileStoreKeyChainAccessor;
import com.terracotta.management.security.shiro.realm.ActiveDirectoryRealm;
import com.terracotta.management.security.shiro.realm.TCJndiLdapContextFactory;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;

public class TMCJndiLdapContextFactory
extends TCJndiLdapContextFactory {
    private static final Logger log = LoggerFactory.getLogger(ActiveDirectoryRealm.class);
    private KeyChainAccessor keyChainAccessor;

    public String getSystemPassword() {
        if (this.getSystemUsername() == null) {
            return null;
        }
        if (this.keyChainAccessor == null) {
            try {
                this.keyChainAccessor = (KeyChainAccessor)ServiceLocator.locate(KeyChainAccessor.class);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (this.keyChainAccessor == null) {
                try {
                    this.keyChainAccessor = new SecretFileStoreKeyChainAccessor();
                }
                catch (KeychainInitializationException e) {
                    throw new RuntimeException("impossible to initialize the keychain", e);
                }
            }
        }
        String aliasFromSystemUsernameAndUrl = this.getAliasFromSystemUsernameAndUrl(this.getUrl(), this.getSimpleSystemUsername());
        String decodedSystemPassword = null;
        try {
            byte[] secret = this.keyChainAccessor.retrieveSecret((KeyName)new URIKeyName(aliasFromSystemUsernameAndUrl));
            decodedSystemPassword = new String(secret, "UTF-8");
        }
        catch (URISyntaxException e) {
            log.debug("Impossible to access the keychain !", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Impossible to read the systempassword for " + aliasFromSystemUsernameAndUrl, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.debug("Impossible to read the systempassword for " + aliasFromSystemUsernameAndUrl, (Throwable)e);
        }
        return decodedSystemPassword;
    }

    String getAliasFromSystemUsernameAndUrl(String url, String systemUsername) {
        String[] split = url.split("://");
        return split[0] + "://" + systemUsername + "@" + split[1];
    }

    public void setKeyChainAccessor(KeyChainAccessor keyChainAccessor) {
        this.keyChainAccessor = keyChainAccessor;
    }
}

