/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.shiro.realm.LdapConfigurationException;
import com.terracotta.management.security.shiro.realm.TMCJndiLdapContextFactory;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LdapConfigurationChecker {
    public static void connectAndCheckConfiguration(String ldapUrl, String searchBase, String systemUsername, Set<String> operatorGroups, Set<String> adminGroups, String userDnTemplate, String groupDnTemplate, String groupAttributeMatching, boolean isStaticGroupMatching) throws LdapConfigurationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "follow");
        boolean isActiveDirectory = userDnTemplate == null;
        String simpleSystemUsername = systemUsername;
        if (systemUsername != null) {
            TMCJndiLdapContextFactory tmcJndiLdapContextFactory = new TMCJndiLdapContextFactory();
            tmcJndiLdapContextFactory.setSimpleSystemUsername(simpleSystemUsername);
            if (!isActiveDirectory) {
                systemUsername = LdapConfigurationChecker.getDnSystemUsername((String)userDnTemplate, (String)systemUsername);
            }
            tmcJndiLdapContextFactory.setSystemUsername(systemUsername);
            tmcJndiLdapContextFactory.setUrl(ldapUrl);
            try {
                env.put("java.naming.security.credentials", tmcJndiLdapContextFactory.getSystemPassword());
            }
            catch (NullPointerException e) {
                throw new LdapConfigurationException("Impossible to retrieve systemUsername password from the keychain : " + tmcJndiLdapContextFactory.getAliasFromSystemUsernameAndUrl(ldapUrl, simpleSystemUsername), (Throwable)e);
            }
            env.put("java.naming.security.principal", systemUsername);
        }
        if (ldapUrl.startsWith("ldaps")) {
            env.put("java.naming.ldap.factory.socket", "com.terracotta.management.security.impl.CustomTrustStoreSSLSocketFactory");
        }
        try {
            InitialLdapContext initialLdapContext = new InitialLdapContext(env, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            if (isActiveDirectory) {
                String searchFilter = "(&(objectClass=*)(CN={0}))";
                HashSet<String> mergedGroups = new HashSet<String>();
                mergedGroups.addAll(operatorGroups);
                mergedGroups.addAll(adminGroups);
                for (String group : mergedGroups) {
                    LdapConfigurationChecker.checkGroupExists((String)searchBase, (DirContext)initialLdapContext, (SearchControls)searchCtls, (String)searchFilter, (String)group);
                }
            } else if (isStaticGroupMatching) {
                HashSet<String> mergedGroups = new HashSet<String>();
                mergedGroups.addAll(operatorGroups);
                mergedGroups.addAll(adminGroups);
                for (String group : mergedGroups) {
                    LdapConfigurationChecker.checkGroupExistsLdap((String)searchBase, (DirContext)initialLdapContext, (SearchControls)searchCtls, (String)(groupDnTemplate.substring(0, groupDnTemplate.indexOf("=")) + "=" + group), (String)group);
                }
                if (!LdapConfigurationChecker.verifyStaticGroupAttributeMatchingIsValid((DirContext)initialLdapContext, (String)groupAttributeMatching, (String)((String)adminGroups.toArray()[0]), (String)groupDnTemplate)) {
                    throw new LdapConfigurationException("Impossible to find the groupMatching attribute : " + groupAttributeMatching + " in the group named : " + adminGroups.toArray()[0] + " . Are you sure you want to use staticGroupMatching ?");
                }
            } else if (systemUsername != null && !LdapConfigurationChecker.verifyDynamicGroupAttributeMatchingIsValid((DirContext)initialLdapContext, (String)searchBase, (String)userDnTemplate, (String)simpleSystemUsername, (String)groupAttributeMatching)) {
                throw new LdapConfigurationException("Impossible to find the groupMatching attribute : " + groupAttributeMatching + " in the user entry named : " + systemUsername + " . Are you sure you want to use dynamicGroupMatching ?");
            }
        }
        catch (NamingException e) {
            if (e.getRootCause() instanceof UnknownHostException) {
                throw new LdapConfigurationException("The host provided in the Ldap URL is not reachable : " + ldapUrl, (Throwable)e);
            }
            if (e.getRootCause() instanceof MalformedURLException) {
                throw new LdapConfigurationException("The provided Ldap URL is not valid : " + ldapUrl, (Throwable)e);
            }
            if (e.getRootCause() instanceof ConnectException) {
                throw new LdapConfigurationException("The connection was refused : " + ldapUrl, (Throwable)e);
            }
            if (e.getRootCause() instanceof SSLHandshakeException) {
                throw new LdapConfigurationException("You can not connect to the secured Ldap server at  : " + ldapUrl + " because you did not import its certificate to your tms-trustore, or you did not ignore certificate errors using -Dtc.ssl.trustAllCerts=true when launching the TMS.", (Throwable)e);
            }
            if (e.getRootCause() instanceof SSLException) {
                throw new LdapConfigurationException("The connection was refused, please check your Ldap server accepts SSL connections : " + ldapUrl, (Throwable)e);
            }
            if (e instanceof ServiceUnavailableException) {
                throw new LdapConfigurationException("The host provided in the Ldap URL does not accept non secured (ldap, not ldaps) connections : " + ldapUrl, (Throwable)e);
            }
            if (e instanceof AuthenticationException) {
                throw new LdapConfigurationException("Cannot authenticate user (did you add your systemUsername password to the keychain ?), please check your systemUsername credentials : " + systemUsername, (Throwable)e);
            }
            if (e instanceof InvalidNameException) {
                throw new LdapConfigurationException("Invalid username : " + systemUsername, (Throwable)e);
            }
            throw new LdapConfigurationException("Your LDAP / Active Directory configuration is not valid, please review your configuration, this information might help you : ", (Throwable)e);
        }
    }

    private static void checkGroupExists(String searchBase, DirContext initialLdapContext, SearchControls searchCtls, String searchFilter, String group) throws NamingException, LdapConfigurationException {
        Object[] searchArguments = new Object[]{group};
        NamingEnumeration<SearchResult> answer = initialLdapContext.search(searchBase, searchFilter, searchArguments, searchCtls);
        if (!answer.hasMoreElements()) {
            throw new LdapConfigurationException("We could not find the specified group in the directory : " + group);
        }
    }

    private static void checkGroupExistsLdap(String searchBase, DirContext initialLdapContext, SearchControls searchCtls, String groupWithPrefix, String group) throws NamingException, LdapConfigurationException {
        NamingEnumeration<SearchResult> answer = initialLdapContext.search(searchBase, groupWithPrefix, searchCtls);
        if (!answer.hasMoreElements()) {
            throw new LdapConfigurationException("We could not find the specified group in the directory : " + group);
        }
    }

    public static String getDnSystemUsername(String userDnTemplate, String systemUsername) {
        return userDnTemplate.replace("{0}", systemUsername);
    }

    private static boolean verifyStaticGroupAttributeMatchingIsValid(DirContext ldapContext, String groupAttributeMatching, String adminGroup, String groupDnTemplate) throws NamingException {
        Attributes attributes = ldapContext.getAttributes(groupDnTemplate.replace("{0}", adminGroup));
        NamingEnumeration<? extends Attribute> all = attributes.getAll();
        while (all.hasMore()) {
            Attribute next = all.next();
            if (!next.getID().equals(groupAttributeMatching)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyDynamicGroupAttributeMatchingIsValid(DirContext ldapContext, String searchBase, String userDnTemplate, String username, String groupAttributeMatching) throws NamingException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ldapContext.search(searchBase, LdapConfigurationChecker.getUserDnPrefix((String)userDnTemplate) + username, searchCtls);
        while (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            Attributes attrs = sr.getAttributes();
            if (attrs == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().equalsIgnoreCase(groupAttributeMatching)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getUserDnPrefix(String userDnTemplate) {
        int index = userDnTemplate.indexOf("{0}");
        return userDnTemplate.substring(0, index);
    }
}

