/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.configuration;

import com.terracotta.management.security.shiro.realm.ActiveDirectoryRealm;
import com.terracotta.management.security.shiro.realm.LdapRealm;
import com.terracotta.management.security.shiro.realm.TMCJndiLdapContextFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.services.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShiroConfigurationGenerator {
    private static final String ACTIVE_DIRECTORY_REALM = "ACTIVE_DIRECTORY_REALM";
    private static final String LDAP_REALM = "LDAP_REALM";
    private static final String TC_INI_REALM = "TC_INI_REALM";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final Logger LOG = LoggerFactory.getLogger(ShiroConfigurationGenerator.class);
    public static final String GLOBAL_SESSION_TIMEOUT = "600000";
    public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
    private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + FILE_SEPARATOR + ".tc" + FILE_SEPARATOR + "mgmt" + FILE_SEPARATOR;
    private static final String CONFIG_LOCATION = System.getProperty("com.tc.management.config.directory", TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "shiro.ini";

    public static void writeShiroConfigurationActiveDirectory(Set<String> operatorGroups, Set<String> adminGroups, String searchBase, String url, String systemUsername) throws IOException {
        ShiroConfigurationGenerator.writeShiroConfiguration((String)"ACTIVE_DIRECTORY_REALM", operatorGroups, adminGroups, null, null, (String)searchBase, (String)url, (String)systemUsername, (boolean)false, null);
    }

    public static void writeShiroConfigurationLdap(Set<String> operatorGroups, Set<String> adminGroups, String userDnTemplate, String groupDnTemplate, String searchBase, String url, String systemUsername, boolean dynamicGroupConfiguration, String groupAttributeMatching) throws IOException {
        ShiroConfigurationGenerator.writeShiroConfiguration((String)"LDAP_REALM", operatorGroups, adminGroups, (String)userDnTemplate, (String)groupDnTemplate, (String)searchBase, (String)url, (String)systemUsername, (boolean)dynamicGroupConfiguration, (String)groupAttributeMatching);
    }

    public static void writeShiroConfigurationIniFile() throws IOException {
        ShiroConfigurationGenerator.writeShiroConfiguration((String)"TC_INI_REALM", null, null, null, null, null, null, null, (boolean)false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeShiroConfiguration(String realmType, Set<String> operatorGroups, Set<String> adminGroups, String userDnTemplate, String groupDnTemplate, String searchBase, String url, String systemUsername, boolean dynamicGroupConfiguration, String groupAttributeMatching) throws IOException {
        InputStream shiroTemplateInputStream = ShiroConfigurationGenerator.class.getClassLoader().getResourceAsStream("shiroTemplate.ini");
        Ini ini = new Ini();
        if (shiroTemplateInputStream != null) {
            ini.load(shiroTemplateInputStream);
            Ini.Section sectionMain = ini.getSection("main");
            Map generatedRealmConfigurationProperties = null;
            if ("TC_INI_REALM".equals(realmType)) {
                generatedRealmConfigurationProperties = ShiroConfigurationGenerator.getTCIniRealmConfigurationProperties();
            } else if ("ACTIVE_DIRECTORY_REALM".equals(realmType)) {
                generatedRealmConfigurationProperties = ShiroConfigurationGenerator.getActiveDirectoryRealmConfigurationProperties(operatorGroups, adminGroups, (String)searchBase, (String)url, (String)systemUsername);
            } else if ("LDAP_REALM".equals(realmType)) {
                generatedRealmConfigurationProperties = ShiroConfigurationGenerator.getLdapRealmConfigurationProperties(operatorGroups, adminGroups, (String)userDnTemplate, (String)groupDnTemplate, (String)searchBase, (String)url, (String)systemUsername, (String)groupAttributeMatching, (boolean)dynamicGroupConfiguration);
            }
            sectionMain.putAll(generatedRealmConfigurationProperties);
            FileWriter outFile = new FileWriter(CONFIG_LOCATION);
            PrintWriter out = new PrintWriter(outFile);
            try {
                for (Ini.Section section : ini.getSections()) {
                    out.println("[" + section.getName() + "]");
                    for (Map.Entry entry : section.entrySet()) {
                        out.println((String)entry.getKey() + " = " + (String)entry.getValue());
                    }
                }
            }
            finally {
                out.close();
            }
            LOG.info("Shiro configuration just got written to : " + CONFIG_LOCATION + " : " + generatedRealmConfigurationProperties);
        } else {
            LOG.error("Impossible to find shiroTemplate.ini; shiro Ldap configuration won't be written");
        }
    }

    static Map<String, String> getTCIniRealmConfigurationProperties() {
        LinkedHashMap<String, String> defaultProps = new LinkedHashMap<String, String>();
        defaultProps.put("realm", "com.terracotta.management.security.shiro.realm.TCIniRealm");
        defaultProps.put("realm.credentialsMatcher", "$passwordMatcher");
        defaultProps.put("realm.cachingEnabled", "false");
        defaultProps.put("realm.authorizationCachingEnabled", "false");
        defaultProps.put("securityManager.realm", "$realm");
        defaultProps.put("securityManager.sessionManager.globalSessionTimeout", "600000");
        return defaultProps;
    }

    static Map<String, String> getActiveDirectoryRealmConfigurationProperties(Set<String> operatorGroups, Set<String> adminGroups, String searchBase, String url, String systemUsername) {
        Map defaultProps = ShiroConfigurationGenerator.getCommonLdapAndADProperties(operatorGroups, adminGroups, (String)searchBase, (String)url, (String)systemUsername);
        defaultProps.put("ldapRealm", ActiveDirectoryRealm.class.getName());
        return defaultProps;
    }

    static Map<String, String> getLdapRealmConfigurationProperties(Set<String> operatorGroups, Set<String> adminGroups, String userDnTemplate, String groupDnTemplate, String searchBase, String url, String systemUsername, String groupAttributeMatching, boolean dynamicGroupConfiguration) {
        LinkedHashMap<String, String> defaultProps = new LinkedHashMap<String, String>();
        defaultProps.put("ldapRealm", LdapRealm.class.getName());
        defaultProps.put("ldapRealm.groupAttributeMatching", groupAttributeMatching);
        defaultProps.put("ldapRealm.userDnTemplate", userDnTemplate);
        defaultProps.put("ldapRealm.groupDnTemplate", groupDnTemplate);
        defaultProps.put("ldapRealm.dynamicGroupConfiguration", Boolean.toString(dynamicGroupConfiguration));
        defaultProps.putAll(ShiroConfigurationGenerator.getCommonLdapAndADProperties(operatorGroups, adminGroups, (String)searchBase, (String)url, (String)systemUsername));
        return defaultProps;
    }

    private static Map<String, String> getCommonLdapAndADProperties(Set<String> operatorGroups, Set<String> adminGroups, String searchBase, String url, String systemUsername) {
        LinkedHashMap<String, String> defaultProps = new LinkedHashMap<String, String>();
        defaultProps.put("contextFactory", TMCJndiLdapContextFactory.class.getName());
        defaultProps.put("ldapRealm.contextFactory", "$contextFactory");
        defaultProps.put("securityManager.realm", "$ldapRealm");
        defaultProps.put("cacheManager", "org.apache.shiro.cache.ehcache.EhCacheManager");
        defaultProps.put("cacheManager.cacheManagerConfigFile", "classpath:shiro-ehcache.xml");
        defaultProps.put("securityManager.cacheManager", "$cacheManager");
        defaultProps.put("securityManager.sessionManager.globalSessionTimeout", "600000");
        ShiroConfigurationGenerator.generateGroupRolesMap(defaultProps, adminGroups, operatorGroups);
        defaultProps.put("ldapRealm.searchBase", searchBase);
        if (Utils.trimToNull((String)systemUsername) != null) {
            defaultProps.put("ldapRealm.systemUsername", systemUsername);
        }
        boolean useCustomTrustStoreSSLSocketFactory = false;
        if (url.startsWith("ldaps")) {
            useCustomTrustStoreSSLSocketFactory = true;
        }
        defaultProps.put("ldapRealm.contextFactory.environment", (useCustomTrustStoreSSLSocketFactory ? "\"java.naming.ldap.factory.socket\":\"com.terracotta.management.security.impl.CustomTrustStoreSSLSocketFactory\"," : "") + "\"java.naming.provider.url\":\"" + url + "\"," + "\"java.naming.factory.initial\":\"com.sun.jndi.ldap.LdapCtxFactory\"," + "\"java.naming.referral\":\"follow\"");
        return defaultProps;
    }

    static void generateGroupRolesMap(Map<String, String> defaultProps, Set<String> adminGroups, Set<String> operatorGroups) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String adminGroup : adminGroups) {
            map.put(adminGroup, "admin");
        }
        for (String operatorGroup : operatorGroups) {
            if (map.containsKey(operatorGroup)) {
                map.put(operatorGroup, "admin,operator");
                continue;
            }
            map.put(operatorGroup, "operator");
        }
        StringBuilder groupRolesMapValue = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            groupRolesMapValue.append("\"" + (String)entry.getKey() + "\":\"" + (String)entry.getValue() + "\",");
        }
        if (groupRolesMapValue.lastIndexOf(",") == groupRolesMapValue.length() - 1) {
            groupRolesMapValue.deleteCharAt(groupRolesMapValue.length() - 1);
        }
        defaultProps.put("ldapRealm.groupRolesMapAsString", groupRolesMapValue.toString());
    }
}

