/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services.validator.impl;

import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;
import java.util.EnumSet;
import java.util.List;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.services.validator.AbstractEhcacheRequestValidator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.Utils;

public class AggregateEhcacheRequestValidator
extends AbstractEhcacheRequestValidator {
    private final Authorizer authorizer;

    public AggregateEhcacheRequestValidator(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void validate(UriInfo info) {
        if (!this.authorizer.isUserInRole(UserRole.ADMIN)) {
            throw new ResourceRuntimeException("Missing role: " + UserRole.ADMIN, Response.Status.UNAUTHORIZED.getStatusCode());
        }
        super.validate(info);
    }

    public void validateSafe(UriInfo info) {
        if (!this.authorizer.isUserInAnyRole(EnumSet.allOf(UserRole.class))) {
            throw new ResourceRuntimeException("User does not have any role", Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    protected void validateAgentSegment(List<PathSegment> pathSegments) {
        String ids = (String)pathSegments.get(0).getMatrixParameters().getFirst((Object)"ids");
        if (Utils.trimToNull((String)ids) == null || ids.split(",").length > 1) {
            throw new ResourceRuntimeException("Unsafe requests must specify a single agent id", Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

