/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.BackupEntity;
import com.terracotta.management.resource.services.BackupResourceService;
import com.terracotta.management.resource.services.impl.AggregateBackupResourceService;
import com.terracotta.management.resource.services.impl.AggregateResourceServiceSupport;
import com.terracotta.management.resource.services.impl.ResourceServiceUtils;
import java.util.Collection;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

@Path(value="/agents/backups")
public class AggregateBackupResourceService
extends AggregateResourceServiceSupport<BackupEntity>
implements BackupResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateBackupResourceService.class);

    public Collection<BackupEntity> backup(UriInfo info) {
        LOG.info(String.format("Invoking AggregateBackupResourceService.backup: %s", info.getRequestUri()));
        String[] agentIds = ResourceServiceUtils.buildAgentIds((UriInfo)info);
        if (agentIds == null || agentIds.length != 1) {
            throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
        }
        Response response = this.getSvcClientSvc().proxyPost(ResourceServiceUtils.cleanURI((UriInfo)info).build(new Object[0]), null, agentIds[0]);
        return (Collection)response.getEntity();
    }

    public Collection<BackupEntity> getBackupStatus(UriInfo info) {
        LOG.info(String.format("Invoking AggregateBackupResourceService.getBackupStatus: %s", info.getRequestUri()));
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        return this.doGet(info, (AggregateCollectionCallback)callback, BackupEntity.class);
    }
}

