/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services.impl;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.config.Agent;
import com.terracotta.management.resource.ErrorEntity;
import com.terracotta.management.resource.ProbeEntity;
import com.terracotta.management.resource.services.impl.AgentMetadataEntityCollectionCallback;
import com.terracotta.management.resource.services.impl.AggregateAgentsResourceService;
import com.terracotta.management.resource.services.impl.AggregateResourceServiceSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.AgentsResourceService;

@Path(value="/agents")
public final class AggregateAgentsResourceService
extends AggregateResourceServiceSupport<AgentEntity>
implements AgentsResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateAgentsResourceService.class);

    public Collection<AgentEntity> getAgents(UriInfo info) {
        LOG.info(String.format("Executing AggregateAgentsResourceService.getAgents: %s", info.getRequestUri()));
        this.getValidator().validateSafe(info);
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        return this.doGet(info, (AggregateCollectionCallback)callback, AgentEntity.class);
    }

    public Collection<AgentMetadataEntity> getAgentsMetadata(UriInfo info) {
        LOG.info(String.format("Invoking AggregateAgentsResourceService.getAgentsMetadata: %s", info.getRequestUri()));
        this.getValidator().validateSafe(info);
        String agentIds = (String)((PathSegment)info.getPathSegments().get(0)).getMatrixParameters().getFirst((Object)"ids");
        if (agentIds != null) {
            throw new ResourceRuntimeException("Cannot use ids matrix parameter on /agents/info", Response.Status.BAD_REQUEST.getStatusCode());
        }
        String path = info.getPath();
        AgentMetadataEntityCollectionCallback callback = new AgentMetadataEntityCollectionCallback(this.getSvcClientSvc().getKnownAgentIds());
        try {
            this.getSvcClientSvc().proxyGet((AggregateCollectionCallback)callback, new URI(path), null, AgentMetadataEntity.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug Alert! Bad path URI from jersey.", e);
        }
        return callback.calculateResult();
    }

    @GET
    @Path(value="/probeUrl/{urlToProbe}")
    @Produces(value={"application/json"})
    public ProbeEntity getAgentInfo(@PathParam(value="urlToProbe") String urlToProbe) throws WebApplicationException {
        ProbeEntity probeEntity;
        Agent agent = this.getNonSecuredAgent(urlToProbe);
        this.getSvcClientSvc().addClient(agent);
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.getSvcClientSvc().proxyGet((AggregateCollectionCallback)callback, new URI("/info"), new String[]{agent.getId()}, AgentMetadataEntity.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug Alert! Bad path URI from jersey.", e);
        }
        Exception exceptionToShow = null;
        for (Object e : callback.getExceptions()) {
            String message = ((Exception)e).getMessage();
            exceptionToShow = (Exception)e;
            if (message.contains("401 Unauthorized")) {
                agent = this.getSecuredAgent(urlToProbe);
                this.getSvcClientSvc().addClient(agent);
                callback = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    this.getSvcClientSvc().proxyGet((AggregateCollectionCallback)callback, new URI("/info"), new String[]{agent.getId()}, AgentMetadataEntity.class);
                }
                catch (URISyntaxException uriSyntaxException) {
                    throw new RuntimeException("Bug Alert! Bad path URI from jersey.", uriSyntaxException);
                }
                if (!callback.calculateResult().isEmpty() || callback.getExceptions().isEmpty()) continue;
                Exception exception = (Exception)callback.getExceptions().get(0);
                throw new ResourceRuntimeException("Impossible to connect to the agent", (Throwable)exception, Response.Status.NOT_FOUND.getStatusCode());
            }
            throw new ResourceRuntimeException("Impossible to connect to the agent", (Throwable)exceptionToShow, Response.Status.NOT_FOUND.getStatusCode());
        }
        Iterator ite = callback.calculateResult().iterator();
        AgentMetadataEntity standaloneOrTsaProbeEntity = (AgentMetadataEntity)ite.next();
        if (callback.calculateResult().size() == 1 && standaloneOrTsaProbeEntity.getAgencyOf().equalsIgnoreCase("ehcache")) {
            probeEntity = new ProbeEntity(standaloneOrTsaProbeEntity);
            probeEntity.setAgentLocation(urlToProbe);
            return probeEntity;
        }
        probeEntity = null;
        if (standaloneOrTsaProbeEntity.getAgencyOf().equalsIgnoreCase("tsa")) {
            probeEntity = this.returnTsaEntityOrThrowsException(standaloneOrTsaProbeEntity.getAgentId(), standaloneOrTsaProbeEntity);
        }
        while (ite.hasNext()) {
            standaloneOrTsaProbeEntity = (AgentMetadataEntity)ite.next();
            if (!standaloneOrTsaProbeEntity.getAgencyOf().equalsIgnoreCase("tsa")) continue;
            probeEntity = this.returnTsaEntityOrThrowsException(standaloneOrTsaProbeEntity.getAgentId(), standaloneOrTsaProbeEntity);
        }
        return probeEntity;
    }

    private ProbeEntity returnTsaEntityOrThrowsException(String agentId, AgentMetadataEntity tsaEntity) {
        4 callback = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.getSvcClientSvc().proxyGet((AggregateCollectionCallback)callback, new URI("/"), new String[]{agentId}, AgentEntity.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug Alert! Bad path URI from jersey.", e);
        }
        Iterator ite2 = callback.calculateResult().iterator();
        if (callback.calculateResult().isEmpty() && !callback.getExceptions().isEmpty()) {
            Exception exception = (Exception)callback.getExceptions().get(0);
            throw new ResourceRuntimeException("Impossible to connect to the TSA agent", (Throwable)exception, Response.Status.NOT_FOUND.getStatusCode());
        }
        if (ite2.hasNext()) {
            AgentEntity tsaAgentEntity = (AgentEntity)ite2.next();
            ProbeEntity probeEntity = new ProbeEntity(tsaEntity);
            probeEntity.setAgentLocation((String)tsaAgentEntity.getRootRepresentables().get("urls"));
            return probeEntity;
        }
        return null;
    }

    private void throwsNotFoundExceptionWithMeaningfulResponse(Exception exception) {
        try {
            UniformInterfaceException uie = (UniformInterfaceException)exception.getCause();
            ClientResponse clientResponse = uie.getResponse();
            ErrorEntity errorEntity = (ErrorEntity)clientResponse.getEntity(ErrorEntity.class);
            errorEntity.setError("The agent is online but returned the following error when we tried to list its info : " + errorEntity.getError());
            Response response = RuntimeDelegate.getInstance().createResponseBuilder().status(Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorEntity).build();
            throw new WebApplicationException(response);
        }
        catch (ClientHandlerException che) {
            throw new NotFoundException(exception.getMessage());
        }
        catch (ClassCastException cce) {
            throw new NotFoundException(exception.getMessage());
        }
        catch (NullPointerException cce) {
            throw new NotFoundException(exception.getMessage());
        }
    }

    private Agent getNonSecuredAgent(String urlToProbe) {
        Agent agent = new Agent();
        agent.setName("probeClient");
        agent.setGroupId("probeGroup");
        agent.setReadTimeoutMillis(Integer.valueOf(60000));
        agent.setConnectionTimeoutMillis(Integer.valueOf(60000));
        agent.setAgentLocation(urlToProbe);
        agent.setSecured(Boolean.valueOf(false));
        agent.setClientAuthEnabled(Boolean.valueOf(false));
        agent.setEnabled(true);
        agent.setType(Agent.TYPE.EHCACHE);
        return agent;
    }

    private Agent getSecuredAgent(String urlToProbe) {
        Agent agent = this.getNonSecuredAgent(urlToProbe);
        agent.setSecured(Boolean.valueOf(true));
        return agent;
    }
}

