/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config.resource.services;

import com.terracotta.management.AgentsUtils;
import com.terracotta.management.config.Agent;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.services.ConfigService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.Utils;

@Path(value="/config")
public final class ConfigResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResourceService.class);
    @Context
    private UriInfo info;
    private final ConfigService configSvc = (ConfigService)ServiceLocator.locate(ConfigService.class);
    private final Authorizer authorizer = (Authorizer)ServiceLocator.locate(Authorizer.class);

    @POST
    @Deprecated
    public void save() {
        try {
            this.configSvc.saveConfig(this.authorizer.getPrincipal());
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Error saving config", (Throwable)see, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @GET
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Collection<Agent> getAgents(@PathParam(value="groupId") String groupId) {
        return this.configSvc.getAgentsByGroup(groupId, this.authorizer.getPrincipal());
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public Collection<String> getGroups() {
        return this.configSvc.getGroups(this.authorizer.getPrincipal());
    }

    @PUT
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Response addGroup(@PathParam(value="groupId") String groupId) {
        boolean added = this.configSvc.addGroup(groupId, this.authorizer.getPrincipal());
        if (added) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group created.").build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Group already exists.").build();
    }

    @PUT
    @Path(value="/groups/{oldGroupId}/{newGroupId}")
    @Produces(value={"application/json"})
    public Response editGroup(@PathParam(value="oldGroupId") String oldGroupId, @PathParam(value="newGroupId") String newGroupId) {
        boolean renamed = this.configSvc.renameGroup(oldGroupId, newGroupId, this.authorizer.getPrincipal());
        if (renamed) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group renamed.").build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Group source group does not exist or destination group already exists.").build();
    }

    @DELETE
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Response deleteGroup(@PathParam(value="groupId") String groupId) {
        boolean deleted = this.configSvc.deleteGroup(groupId, this.authorizer.getPrincipal());
        if (deleted) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group deleted.").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Group does not exist or is not empty.").build();
    }

    @GET
    @Path(value="/agents")
    @Produces(value={"application/json"})
    public Collection<Agent> getAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Collection groups = this.configSvc.getGroups(this.authorizer.getPrincipal());
        for (String groupId : groups) {
            Collection agentsByGroup = this.configSvc.getAgentsByGroup(groupId, this.authorizer.getPrincipal());
            agents.addAll(agentsByGroup);
        }
        return agents;
    }

    @POST
    @Path(value="/agents")
    @Consumes(value={"application/json"})
    public Response addAgent(Agent agent) {
        Response.ResponseBuilder responseBuilder;
        agent.setUsername(this.authorizer.getPrincipal());
        this.isValidAgentLocation(agent);
        if (Utils.trimToNull((String)agent.getName()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing name.");
        } else if (Utils.trimToNull((String)agent.getGroupId()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing groupId.");
        } else if (agent.getAgentLocation() == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing agentLocation.");
        } else if (!this.isValidAgentLocation(agent)) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Invalid agentLocation.");
        } else {
            try {
                if (this.configSvc.addAgent(agent, this.authorizer.getPrincipal())) {
                    this.configSvc.saveConfig(this.authorizer.getPrincipal());
                    UriBuilder builder = this.info.getRequestUriBuilder();
                    builder.segment(new String[]{agent.getId()});
                    responseBuilder = Response.status((Response.Status)Response.Status.CREATED).header("LOCATION", (Object)builder.build(new Object[0]));
                } else {
                    responseBuilder = Response.status((Response.Status)Response.Status.CONFLICT);
                }
            }
            catch (ServiceExecutionException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
            }
        }
        return responseBuilder.build();
    }

    @GET
    @Path(value="/agents/{agentId}")
    @Produces(value={"application/json"})
    public Agent getAgent(@PathParam(value="agentId") String agentId) {
        return this.configSvc.getAgent(agentId, this.authorizer.getPrincipal());
    }

    @DELETE
    @Path(value="/agents/{agentId}")
    public Response deleteAgent(@PathParam(value="agentId") String agentId) {
        Response.ResponseBuilder responseBuilder = null;
        this.configSvc.deleteAgent(agentId, this.authorizer.getPrincipal());
        try {
            this.configSvc.saveConfig(this.authorizer.getPrincipal());
        }
        catch (ServiceExecutionException e) {
            responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
        }
        return responseBuilder != null ? responseBuilder.build() : null;
    }

    @PUT
    @Path(value="/agents/{agentId}")
    @Consumes(value={"application/json"})
    public Response updateAgent(@PathParam(value="agentId") String agentId, Agent agent) {
        Response.ResponseBuilder responseBuilder;
        agent.setUsername(this.authorizer.getPrincipal());
        if (Utils.trimToNull((String)agent.getName()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing name.");
        } else if (Utils.trimToNull((String)agent.getGroupId()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing groupId.");
        } else if (agent.getAgentLocation() == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing agentLocation.");
        } else if (!this.isValidAgentLocation(agent)) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Invalid agentLocation.");
        } else {
            try {
                if (this.configSvc.updateAgent(agentId, agent, this.authorizer.getPrincipal())) {
                    this.configSvc.saveConfig(this.authorizer.getPrincipal());
                    responseBuilder = Response.ok();
                } else {
                    responseBuilder = Response.status((Response.Status)Response.Status.NOT_MODIFIED);
                }
            }
            catch (ServiceExecutionException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
            }
        }
        return responseBuilder.build();
    }

    private boolean isValidAgentLocation(Agent agent) {
        boolean valid = true;
        try {
            if (agent.getType().equals((Object)Agent.TYPE.TSA)) {
                AgentsUtils.checkTsaAgentLocationsAndReturnFirstValidOne((Agent)agent);
            } else {
                new URL(agent.getAgentLocation());
            }
        }
        catch (MalformedURLException e) {
            valid = false;
        }
        return valid;
    }
}

