/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config.jaxb.adapters;

import com.terracotta.management.config.Agent;
import com.terracotta.management.config.jaxb.adapters.Cluster;
import com.terracotta.management.config.jaxb.adapters.Group;
import com.terracotta.management.config.jaxb.adapters.MonitoredClustersAdapter;
import com.terracotta.management.config.jaxb.adapters.MonitoredGroupsAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="config")
public final class Config {
    @XmlJavaTypeAdapter(value=MonitoredGroupsAdapter.class)
    private List<Group> monitoredGroups;
    @XmlJavaTypeAdapter(value=MonitoredClustersAdapter.class)
    private List<Cluster> monitoredClusters;

    public List<Group> getMonitoredGroups() {
        return this.monitoredGroups;
    }

    public void setMonitoredGroups(List<Group> monitoredGroups) {
        this.monitoredGroups = monitoredGroups;
    }

    public List<Cluster> getMonitoredClusters() {
        return this.monitoredClusters;
    }

    public void setMonitoredClusters(List<Cluster> monitoredClusters) {
        this.monitoredClusters = monitoredClusters;
    }

    public Map<String, Collection<Agent>> getMonitored() {
        ConcurrentHashMap<String, Collection<Agent>> agents = new ConcurrentHashMap<String, Collection<Agent>>();
        if (this.monitoredGroups != null) {
            for (Group group : this.monitoredGroups) {
                if (group.getAgents() == null) continue;
                agents.put(group.getId(), group.getAgents());
            }
        }
        if (this.monitoredClusters != null) {
            for (Cluster cluster : this.monitoredClusters) {
                if (cluster.getAgents() == null) continue;
                agents.put(cluster.getId(), cluster.getAgents());
            }
        }
        return agents;
    }
}

