/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config;

import com.terracotta.management.config.Agent;
import com.terracotta.management.config.jaxb.adapters.Cluster;
import com.terracotta.management.config.jaxb.adapters.Group;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public final class Config
extends Observable {
    private final ConcurrentHashMap<String, ConcurrentMap<String, Agent>> agentsByGroupById = new ConcurrentHashMap();
    private final String username;

    public Config(String username) {
        this.username = username;
    }

    public Config(Map<String, Collection<Agent>> monitored, String username) {
        this.username = username;
        for (Map.Entry<String, Collection<Agent>> groupEntry : monitored.entrySet()) {
            this.addGroup(groupEntry.getKey());
            for (Agent agent : groupEntry.getValue()) {
                agent.setUsername(username);
                this.addAgent(agent);
            }
        }
    }

    public void agentsChanged(String agentId) {
        this.setChanged();
        this.notifyObservers((Object)agentId);
    }

    public Set<String> getGroups() {
        return Collections.unmodifiableSet(this.agentsByGroupById.keySet());
    }

    public boolean addGroup(String groupId) {
        ConcurrentHashMap old = this.agentsByGroupById.putIfAbsent(groupId, new ConcurrentHashMap());
        return old == null;
    }

    public boolean deleteGroup(String groupId) {
        boolean deleted = false;
        Collection agents = this.getAgentsByGroup(groupId);
        if (agents != null) {
            for (Agent agent : this.getAgentsByGroup(groupId)) {
                this.deleteAgent(agent.getId());
            }
            deleted = this.agentsByGroupById.remove(groupId, Collections.emptyMap());
        }
        return deleted;
    }

    public boolean renameGroup(String oldGroupId, String newGroupId) {
        ConcurrentMap oldGroup = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (oldGroup == null) {
            return false;
        }
        ConcurrentHashMap<String, Agent> newGroup = new ConcurrentHashMap<String, Agent>();
        for (Map.Entry entry : oldGroup.entrySet()) {
            Agent oldAgent = (Agent)entry.getValue();
            Agent newAgent = new Agent(oldAgent);
            newAgent.setGroupId(newGroupId);
            newGroup.put(newAgent.getName(), newAgent);
        }
        ConcurrentMap current = this.agentsByGroupById.putIfAbsent(newGroupId, newGroup);
        if (current == null) {
            this.agentsByGroupById.remove(oldGroupId);
            for (Map.Entry entry : oldGroup.entrySet()) {
                this.agentsChanged(((Agent)entry.getValue()).getId());
            }
            for (Map.Entry entry : newGroup.entrySet()) {
                this.agentsChanged(((Agent)entry.getValue()).getId());
            }
            return true;
        }
        return false;
    }

    public Agent getAgent(String agentId) {
        String name = Agent.nameOfId((String)agentId);
        String groupId = Agent.groupOfId((String)agentId);
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(groupId);
        return agentsMap != null ? (Agent)agentsMap.get(name) : null;
    }

    public Collection<Agent> getAgentsByGroup(String groupId) {
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(groupId);
        if (agentsMap == null) {
            return null;
        }
        return agentsMap.values();
    }

    public Agent deleteAgent(String agentId) {
        String oldName = Agent.nameOfId((String)agentId);
        String oldGroupId = Agent.groupOfId((String)agentId);
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (agentsMap == null) {
            return null;
        }
        Agent oldValue = (Agent)agentsMap.remove(oldName);
        if (oldValue == null) {
            return null;
        }
        this.agentsChanged(agentId);
        return oldValue;
    }

    public boolean addAgent(Agent agent) {
        String name = agent.getName();
        String groupId = agent.getGroupId();
        ConcurrentHashMap<String, Agent> agentsMap = (ConcurrentHashMap<String, Agent>)this.agentsByGroupById.get(groupId);
        if (agentsMap == null) {
            agentsMap = new ConcurrentHashMap<String, Agent>();
            this.agentsByGroupById.put(groupId, agentsMap);
        }
        if (agentsMap.containsKey(name)) {
            return false;
        }
        agentsMap.put(name, agent);
        this.agentsChanged(agent.getId());
        return true;
    }

    public boolean updateAgent(String agentId, Agent agent) {
        String oldName = Agent.nameOfId((String)agentId);
        String oldGroupId = Agent.groupOfId((String)agentId);
        String newName = agent.getName();
        String newGroupId = agent.getGroupId();
        ConcurrentMap oldAgentGroup = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (oldAgentGroup == null) {
            return false;
        }
        ConcurrentHashMap<String, Agent> newAgentGroup = (ConcurrentHashMap<String, Agent>)this.agentsByGroupById.get(newGroupId);
        if (newAgentGroup == null) {
            newAgentGroup = new ConcurrentHashMap<String, Agent>();
            this.agentsByGroupById.put(newGroupId, newAgentGroup);
        }
        if (oldAgentGroup != newAgentGroup && newAgentGroup.containsKey(newName)) {
            return false;
        }
        Agent oldValue = (Agent)oldAgentGroup.remove(oldName);
        if (oldValue == null) {
            return false;
        }
        this.agentsChanged(agentId);
        newAgentGroup.put(newName, agent);
        this.agentsChanged(agent.getId());
        return true;
    }

    public String toString() {
        return "Config{agentsByGroupById=" + this.agentsByGroupById + '}';
    }

    public static Config load(InputStream is, String username) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.terracotta.management.config.jaxb.adapters.Config.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        com.terracotta.management.config.jaxb.adapters.Config ac = (com.terracotta.management.config.jaxb.adapters.Config)com.terracotta.management.config.jaxb.adapters.Config.class.cast(jaxbUnmarshaller.unmarshal(is));
        return new Config(ac.getMonitored(), username);
    }

    public static void write(Config config, File configFile) throws JAXBException, IOException {
        File parent = configFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        configFile.createNewFile();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.terracotta.management.config.jaxb.adapters.Config.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        com.terracotta.management.config.jaxb.adapters.Config ac = new com.terracotta.management.config.jaxb.adapters.Config();
        config.addGroupsAndClustersToPersistedConfig(ac);
        jaxbMarshaller.marshal((Object)ac, configFile);
    }

    private void addGroupsAndClustersToPersistedConfig(com.terracotta.management.config.jaxb.adapters.Config ac) {
        ArrayList<Group> monitoredGroups = new ArrayList<Group>();
        ArrayList<Cluster> monitoredClusters = new ArrayList<Cluster>();
        for (String groupId : this.getGroups()) {
            Collection agentsByGroup = this.getAgentsByGroup(groupId);
            boolean areAgentsPartOfACluster = this.areAgentsPartOfACluster(agentsByGroup);
            if (areAgentsPartOfACluster) {
                Cluster cluster = new Cluster();
                cluster.setId(groupId);
                cluster.setAgents(new ArrayList(agentsByGroup));
                monitoredClusters.add(cluster);
                continue;
            }
            Group group = new Group();
            group.setId(groupId);
            group.setAgents(new ArrayList(agentsByGroup));
            monitoredGroups.add(group);
        }
        ac.setMonitoredClusters(monitoredClusters);
        ac.setMonitoredGroups(monitoredGroups);
    }

    Map<String, Collection<Agent>> getMonitored() {
        HashMap<String, Collection<Agent>> monitored = new HashMap<String, Collection<Agent>>();
        for (String groupId : this.getGroups()) {
            Collection agentsByGroup = this.getAgentsByGroup(groupId);
            monitored.put(groupId, agentsByGroup);
        }
        return monitored;
    }

    private boolean areAgentsPartOfACluster(Collection<Agent> agentsByGroup) {
        for (Agent agent : agentsByGroup) {
            if (agent.getType() != Agent.TYPE.TSA) continue;
            return true;
        }
        return false;
    }

    public String getUsername() {
        return this.username;
    }
}

