/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config;

import com.terracotta.management.config.Agent;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.terracotta.management.resource.AgentMetadataEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public final class Agent {
    public static final String SPLIT_GROUP_AND_NAME = "_%_%_";
    private TYPE type;
    private String name;
    private String groupId;
    private String agentLocation;
    private Integer connectionTimeoutMillis;
    private Integer readTimeoutMillis;
    private Boolean secured;
    private Boolean clientAuthEnabled;
    private Integer sampleHistorySize = 30;
    private Integer sampleIntervalSeconds = 1;
    private Boolean enabled = true;
    private String username;

    public Agent() {
    }

    public Agent(Agent source) {
        this.name = source.getName();
        this.groupId = source.getGroupId();
        this.agentLocation = source.getAgentLocation();
        this.connectionTimeoutMillis = source.getConnectionTimeoutMillis();
        this.readTimeoutMillis = source.getReadTimeoutMillis();
        this.secured = source.isSecured();
        this.clientAuthEnabled = source.isClientAuthEnabled();
        this.sampleHistorySize = source.getSampleHistorySize();
        this.sampleIntervalSeconds = source.getSampleIntervalSeconds();
        this.enabled = source.isEnabled();
        this.username = source.getUsername();
        this.type = source.getType();
    }

    public String getId() {
        if (this.groupId == null || this.name == null) {
            return null;
        }
        return this.groupId + SPLIT_GROUP_AND_NAME + this.name;
    }

    public static String groupOfId(String id) {
        if (id == null) {
            return null;
        }
        return id.split(SPLIT_GROUP_AND_NAME)[0];
    }

    public static String nameOfId(String id) {
        if (id == null) {
            return null;
        }
        return id.split(SPLIT_GROUP_AND_NAME)[1];
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @XmlAttribute
    public String getAgentLocation() {
        return this.agentLocation;
    }

    public List<String> getAgentsLocations() {
        if (TYPE.TSA != this.type) {
            throw new UnsupportedOperationException("You can not call getAgentsLocations() on a non TSA agent!");
        }
        String[] split = this.agentLocation.split(",");
        return Arrays.asList(split);
    }

    @XmlAttribute
    public Integer getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @XmlAttribute
    public Integer getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @XmlAttribute
    public Boolean isClientAuthEnabled() {
        return this.clientAuthEnabled == null ? Boolean.FALSE : this.clientAuthEnabled;
    }

    @XmlAttribute
    public Boolean isSecured() {
        return this.secured == null ? Boolean.FALSE : this.secured;
    }

    @XmlAttribute
    public Integer getSampleHistorySize() {
        return this.sampleHistorySize;
    }

    @XmlAttribute
    public Integer getSampleIntervalSeconds() {
        return this.sampleIntervalSeconds;
    }

    @XmlAttribute
    public Boolean isEnabled() {
        return this.enabled == null ? Boolean.FALSE : this.enabled;
    }

    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public TYPE getType() {
        return this.type;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setAgentLocation(String agentLocation) {
        this.agentLocation = agentLocation;
    }

    public void setConnectionTimeoutMillis(Integer connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setReadTimeoutMillis(Integer readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public void setClientAuthEnabled(Boolean clientAuthEnabled) {
        this.clientAuthEnabled = clientAuthEnabled;
    }

    public void setSampleHistorySize(Integer sampleHistorySize) {
        this.sampleHistorySize = sampleHistorySize;
    }

    public void setSampleIntervalSeconds(Integer sampleIntervalSeconds) {
        this.sampleIntervalSeconds = sampleIntervalSeconds;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public boolean update(AgentMetadataEntity agentMetadataEntity) {
        boolean updated = false;
        if (agentMetadataEntity.isEnabled() != this.isEnabled().booleanValue()) {
            this.setEnabled(agentMetadataEntity.isEnabled());
            updated = true;
        }
        if (agentMetadataEntity.isSecured() != this.isSecured().booleanValue()) {
            this.setSecured(Boolean.valueOf(agentMetadataEntity.isSecured()));
            updated = true;
        }
        if (agentMetadataEntity.isNeedClientAuth() != this.isClientAuthEnabled().booleanValue()) {
            this.setClientAuthEnabled(Boolean.valueOf(agentMetadataEntity.isNeedClientAuth()));
            updated = true;
        }
        if (agentMetadataEntity.getSampleHistorySize() != this.getSampleHistorySize().intValue()) {
            this.setSampleHistorySize(Integer.valueOf(agentMetadataEntity.getSampleHistorySize()));
            updated = true;
        }
        if (agentMetadataEntity.getSampleIntervalSeconds() != this.getSampleIntervalSeconds().intValue()) {
            this.setSampleIntervalSeconds(Integer.valueOf(agentMetadataEntity.getSampleIntervalSeconds()));
            updated = true;
        }
        return updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Agent agent = (Agent)o;
        String id = this.getId();
        return !(id != null ? !id.equals(agent.getId()) : agent.getId() != null);
    }

    public int hashCode() {
        String id = this.getId();
        return id != null ? id.hashCode() : 0;
    }

    public String toString() {
        return "Agent{name='" + this.name + '\'' + ", groupId='" + this.groupId + '\'' + ", agentLocation='" + this.agentLocation + '\'' + ", connectionTimeoutMillis=" + this.connectionTimeoutMillis + ", readTimeoutMillis=" + this.readTimeoutMillis + ", secured=" + this.secured + ", clientAuthEnabled=" + this.clientAuthEnabled + ", sampleHistorySize=" + this.sampleHistorySize + ", sampleIntervalSeconds=" + this.sampleIntervalSeconds + ", enabled=" + this.enabled + ", username=" + this.username + ", type=" + this.type + '}';
    }
}

