/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.terracotta.management.resource.Representable;

public abstract class AggregateCollectionCallback<RESOURCE extends Representable> {
    protected Collection<Collection<RESOURCE>> responses = new ArrayList();
    protected List<Exception> exceptions = new ArrayList();

    public void addResponses(Collection<RESOURCE> response) {
        this.responses.add(response);
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public Collection<RESOURCE> calculateResult() {
        HashSet result = new HashSet();
        for (Collection r : this.responses) {
            result.addAll(r);
        }
        return result;
    }

    public List<Exception> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

