/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package com.terracotta.management.services;

import org.terracotta.management.ServiceExecutionException;

/**
 * @author Anthony Dahanne
 */
public interface SystemConfigService {

  boolean isAuthenticationEnabled();

  boolean isTmsTruststoreUsedForHttpsAgents();

  void setAuthenticationEnabled(boolean authenticationEnabled) throws ServiceExecutionException;

  void setAndSaveTmsTrustoreUsedForHttpsAgents(boolean useTmsTrustore) throws ServiceExecutionException;

  boolean isFirstRun();

  /**
   * Check whether or not SSL is configured with both a keystore and a truststore
   *
   * @return true if SSL is configured with both a keystore and a truststore
   */
  boolean storesAndKeychainExist();

  String getTmcConfigurationDirectory();


}
