/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.services;

import com.terracotta.management.config.Agent;
import org.terracotta.management.ServiceExecutionException;

import java.util.Collection;
import java.util.Observer;

/**
 * <p>A service interface for managing agent configuration.</p>
 *
 * @author brandony
 */
public interface ConfigService {
  Collection<Agent> getAgentsByGroup(String groupId, String username);

  Collection<String> getGroups(String username);

  boolean addGroup(String groupId, String username);

  boolean deleteGroup(String groupId, String username);

  boolean renameGroup(String oldGroupId, String newGroupId, String username);

  Agent getAgent(String agentId, String username);

  Collection<Agent> getAgents();

  void deleteAgent(String agentId, String username);
  
  boolean addAgent(Agent agent, String username);

  boolean updateAgent(String agentId, Agent agent, String username);

  boolean saveConfig(String username) throws ServiceExecutionException;
  
  void registerObserver(Observer observer);

}
