/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.web.shiro;

import org.apache.shiro.web.servlet.ShiroFilter;
import org.terracotta.management.ServiceLocator;
import com.terracotta.management.services.SystemConfigService;

/**
 * @author brandony
 */
public final class TMSSecurityFilter extends ShiroFilter {
  @Override
  public void init() throws Exception {
    if(TMSEnvironmentLoaderListener.HAS_LICENSE &&  ServiceLocator.locate(SystemConfigService.class).isAuthenticationEnabled()) {
      super.init();
    } else {
      setEnabled(false);
    }
  }
}
