/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.validator.impl;

import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;
import net.sf.ehcache.management.resource.services.validator.AbstractEhcacheRequestValidator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.Utils;

import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.util.EnumSet;
import java.util.List;

/**
 * @author brandony
 */
public class AggregateEhcacheRequestValidator extends AbstractEhcacheRequestValidator {
  private final Authorizer authorizer;

  public AggregateEhcacheRequestValidator(Authorizer authorizer) {
    this.authorizer = authorizer;
  }

  @Override
  public void validate(UriInfo info) {
    if (!authorizer.isUserInRole(UserRole.ADMIN)) {
      //TODO: shouldn't that be Response.Status.FORBIDDEN ?
      throw new ResourceRuntimeException("Missing role: " + UserRole.ADMIN, Response.Status.UNAUTHORIZED.getStatusCode());
    }
    super.validate(info);    //To change body of overridden methods use File | Settings | File Templates.
  }

  @Override
  public void validateSafe(UriInfo info) {
    if (!authorizer.isUserInAnyRole(EnumSet.allOf(UserRole.class))) {
      //TODO: shouldn't that be Response.Status.FORBIDDEN ?
      throw new ResourceRuntimeException("User does not have any role", Response.Status.UNAUTHORIZED.getStatusCode());
    }
  }

  @Override
  protected void validateAgentSegment(List<PathSegment> pathSegments) {
    String ids = pathSegments.get(0).getMatrixParameters().getFirst("ids");

    if (Utils.trimToNull(ids) == null || ids.split(",").length > 1) {
      throw new ResourceRuntimeException("Unsafe requests must specify a single agent id", Response.Status.BAD_REQUEST.getStatusCode());
    }
  }
}
