/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.TopologyEntity;
import com.terracotta.management.resource.services.TopologyResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/topologies")
public class AggregateTopologyResourceService extends AggregateResourceServiceSupport<TopologyEntity> implements TopologyResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateTopologyResourceService.class);

  @Override
  public Collection<TopologyEntity> getTopologies(UriInfo info) {
    LOG.info(String.format("Invoking AggregateTopologyResourceService.getTopologies: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<TopologyEntity> callback = new AggregateCollectionCallback<TopologyEntity>() {
    };

    return doGet(info, callback, TopologyEntity.class);
  }

  @Override
  public Collection<TopologyEntity> getServerTopologies(UriInfo info) {
    LOG.info(String.format("Invoking AggregateTopologyResourceService.getServerTopologies: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<TopologyEntity> callback = new AggregateCollectionCallback<TopologyEntity>() {
    };

    return doGet(info, callback, TopologyEntity.class);
  }

  @Override
  public Collection<TopologyEntity> getConnectedClients(UriInfo info) {
    LOG.info(String.format("Invoking AggregateTopologyResourceService.getConnectedClients: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<TopologyEntity> callback = new AggregateCollectionCallback<TopologyEntity>() {
    };

    return doGet(info, callback, TopologyEntity.class);
  }
}
