/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import com.terracotta.management.resource.ThreadDumpEntity;
import com.terracotta.management.resource.services.ShutdownResourceService;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/shutdown")
public class AggregateShutdownResourceService extends AggregateResourceServiceSupport<ThreadDumpEntity>
    implements ShutdownResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateShutdownResourceService.class);

  @Override
  public void shutdown(UriInfo info) {
    LOG.info(String.format("Invoking AggregateShutdownResourceService.shutdown: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    getSvcClientSvc().proxyPost(ResourceServiceUtils.cleanURI(info).build(), null, agentIds[0]);
  }

}
