/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.OperatorEventEntity;
import com.terracotta.management.resource.services.OperatorEventsResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/operatorEvents")
public class AggregateOperatorEventsResourceService extends AggregateResourceServiceSupport<OperatorEventEntity>
    implements OperatorEventsResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateOperatorEventsResourceService.class);

  @Override
  public Collection<OperatorEventEntity> getOperatorEvents(UriInfo info) {
    LOG.info(String.format("Invoking AggregateLogsResourceService.getOperatorEvents: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<OperatorEventEntity> callback = new AggregateCollectionCallback<OperatorEventEntity>() {
    };

    return doGet(info, callback, OperatorEventEntity.class);
  }

  @Override
  public boolean markOperatorEventAsRead(UriInfo info, Collection<OperatorEventEntity> operatorEventEntities) {
    LOG.info(String.format("Invoking AggregateLogsResourceService.markOperatorEventAsRead: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    return (Boolean) getSvcClientSvc()
        .proxyPost(ResourceServiceUtils.cleanURI(info).build(), operatorEventEntities, agentIds[0]).getEntity();
  }

  @Override
  public boolean markOperatorEventAsUnread(UriInfo info, Collection<OperatorEventEntity> operatorEventEntities) {
    LOG.info(String.format("Invoking AggregateLogsResourceService.markOperatorEventAsUnread: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    return (Boolean) getSvcClientSvc()
        .proxyPost(ResourceServiceUtils.cleanURI(info).build(), operatorEventEntities, agentIds[0]).getEntity();
  }
}
