/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.StatisticsEntity;
import com.terracotta.management.resource.services.MonitoringResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/statistics")
public class AggregateMonitoringResourceService extends AggregateResourceServiceSupport<StatisticsEntity>
    implements MonitoringResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateMonitoringResourceService.class);

  @Override
  public Collection<StatisticsEntity> getServerStatistics(UriInfo info) {
    LOG.info(String.format("Invoking AggregateMonitoringResourceService.getServerStatistics: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<StatisticsEntity> callback = new AggregateCollectionCallback<StatisticsEntity>() {
    };

    return doGet(info, callback, StatisticsEntity.class);
  }

  @Override
  public Collection<StatisticsEntity> getDgcStatistics(UriInfo info) {
    LOG.info(String.format("Invoking AggregateMonitoringResourceService.getDgcStatistics: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<StatisticsEntity> callback = new AggregateCollectionCallback<StatisticsEntity>() {
    };

    return doGet(info, callback, StatisticsEntity.class);
  }

  @Override
  public Collection<StatisticsEntity> getClientStatistics(UriInfo info) {
    LOG.info(String.format("Invoking AggregateMonitoringResourceService.getClientStatistics: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<StatisticsEntity> callback = new AggregateCollectionCallback<StatisticsEntity>() {
    };

    return doGet(info, callback, StatisticsEntity.class);
  }
}
