/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.LogEntity;
import com.terracotta.management.resource.services.LogsResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/logs")
public class AggregateLogsResourceService extends AggregateResourceServiceSupport<LogEntity>
    implements LogsResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateLogsResourceService.class);

  @Override
  public Collection<LogEntity> getLogs(UriInfo info) {
    LOG.info(String.format("Invoking AggregateLogsResourceService.getLogs: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<LogEntity> callback = new AggregateCollectionCallback<LogEntity>() {
    };

    return doGet(info, callback, LogEntity.class);
  }

}
