/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.ThreadDumpEntity;
import com.terracotta.management.resource.TopologyReloadStatusEntity;
import com.terracotta.management.resource.services.DiagnosticsResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/diagnostics")
public class AggregateDiagnosticsResourceService extends AggregateResourceServiceSupport<ThreadDumpEntity>
    implements DiagnosticsResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateDiagnosticsResourceService.class);

  @Override
  public Collection<ThreadDumpEntity> clusterThreadDump(UriInfo info) {
    LOG.info(String.format("Invoking AggregateDiagnosticsResourceService.clusterThreadDump: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<ThreadDumpEntity> callback = new AggregateCollectionCallback<ThreadDumpEntity>() {
    };

    return doGet(info, callback, ThreadDumpEntity.class);
  }

  @Override
  public Collection<ThreadDumpEntity> serversThreadDump(UriInfo info) {
    LOG.info(String.format("Invoking AggregateDiagnosticsResourceService.serversThreadDump: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<ThreadDumpEntity> callback = new AggregateCollectionCallback<ThreadDumpEntity>() {
    };

    return doGet(info, callback, ThreadDumpEntity.class);
  }

  @Override
  public Collection<ThreadDumpEntity> clientsThreadDump(UriInfo info) {
    LOG.info(String.format("Invoking AggregateDiagnosticsResourceService.clientsThreadDump: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<ThreadDumpEntity> callback = new AggregateCollectionCallback<ThreadDumpEntity>() {
    };

    return doGet(info, callback, ThreadDumpEntity.class);
  }

  @Override
  public boolean runDgc(UriInfo info) {
    LOG.info(String.format("Invoking AggregateDiagnosticsResourceService.runDgc: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    Response response = getSvcClientSvc()
        .proxyPost(ResourceServiceUtils.cleanURI(info).build(), null, agentIds[0]);

    return (Boolean)response.getEntity();
  }

  @Override
  public Collection<TopologyReloadStatusEntity> reloadConfiguration(UriInfo info) {
    LOG.info(String.format("Invoking AggregateDiagnosticsResourceService.reloadConfiguration: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    Response response = getSvcClientSvc()
        .proxyPost(ResourceServiceUtils.cleanURI(info).build(), null, agentIds[0]);

    return (Collection<TopologyReloadStatusEntity>)response.getEntity();
  }
}
