/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.ConfigEntity;
import com.terracotta.management.resource.services.ConfigurationResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/configurations")
public class AggregateConfigurationResourceService extends AggregateResourceServiceSupport<ConfigEntity>
    implements ConfigurationResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateConfigurationResourceService.class);

  @Override
  public Collection<ConfigEntity> geConfigs(UriInfo info) {
    LOG.info(String.format("Invoking AggregateConfigurationResourceService.geConfigs: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    AggregateCollectionCallback<ConfigEntity> callback = new AggregateCollectionCallback<ConfigEntity>() {
    };

    return doGet(info, callback, ConfigEntity.class);
  }

  @Override
  public Collection<ConfigEntity> getClientConfigs(UriInfo info) {
    LOG.info(String.format("Invoking AggregateConfigurationResourceService.getClientConfigs: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    AggregateCollectionCallback<ConfigEntity> callback = new AggregateCollectionCallback<ConfigEntity>() {
    };

    return doGet(info, callback, ConfigEntity.class);
  }

  @Override
  public Collection<ConfigEntity> getServerConfigs(UriInfo info) {
    LOG.info(String.format("Invoking AggregateConfigurationResourceService.getServerConfigs: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    AggregateCollectionCallback<ConfigEntity> callback = new AggregateCollectionCallback<ConfigEntity>() {
    };

    return doGet(info, callback, ConfigEntity.class);
  }
}
