/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.services.CachesResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.util.Collection;

/**
 * <p>
 * An aggregate implementation of {@link CachesResourceService}.
 * </p>
 *
 * @author brandony
 */
@Path("/agents/cacheManagers/caches")
public final class AggregateCachesResourceService extends AggregateResourceServiceSupport<CacheEntity>
    implements CachesResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateCachesResourceService.class);

  public AggregateCachesResourceService() {
    super();
  }

  /**
   * @see net.sf.ehcache.management.resource.services.CachesResourceService#getCaches(javax.ws.rs.core.UriInfo)
   */
  @Override
  public Collection<CacheEntity> getCaches(UriInfo info) {
    getValidator().validateSafe(info);
    LOG.info(
        String.format("Invoking AggregateCachesResourceService.getCaches: %s", info.getRequestUri()));

    AggregateCollectionCallback<CacheEntity> callback = new AggregateCollectionCallback<CacheEntity>() {
    };

    return doGet(info, callback, CacheEntity.class);
  }

  /**
   * @see net.sf.ehcache.management.resource.services.CachesResourceService#createOrUpdateCache(javax.ws.rs.core.UriInfo, net.sf.ehcache.management.resource.CacheEntity)
   */
  @Override
  public void createOrUpdateCache(UriInfo info,
                                  CacheEntity resource) {
    LOG.info(
        String.format("Invoking AggregateCachesResourceService.createOrUpdateCache: %s", info.getRequestUri()));
    getValidator().validate(info);

    getSvcClientSvc()
        .proxyPut(ResourceServiceUtils.cleanURI(info).build(), resource, ResourceServiceUtils.buildAgentIds(info)[0]);
  }

  /**
   * @see net.sf.ehcache.management.resource.services.CachesResourceService#deleteCache(javax.ws.rs.core.UriInfo)
   */
  @Override
  public void deleteCache(UriInfo info) {
    LOG.info(
        String.format("Invoking AggregateCachesResourceService.deleteCache: %s", info.getRequestUri()));
    getValidator().validate(info);
    // TODO: Implement me!
    throw new ResourceRuntimeException("Not implemented", Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
  }
}
