/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.resource.BackupEntity;
import com.terracotta.management.resource.services.BackupResourceService;

import java.util.Collection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author Ludovic Orban
 */
@Path("/agents/backups")
public class AggregateBackupResourceService extends AggregateResourceServiceSupport<BackupEntity>
    implements BackupResourceService {

  private static final Logger LOG = LoggerFactory.getLogger(AggregateBackupResourceService.class);

  @Override
  public Collection<BackupEntity> backup(UriInfo info) {
    LOG.info(String.format("Invoking AggregateBackupResourceService.backup: %s",
        info.getRequestUri()));

    String[] agentIds = ResourceServiceUtils.buildAgentIds(info);
    if (agentIds == null || agentIds.length != 1) {
      throw new ResourceRuntimeException("Missing agent ID", Response.Status.BAD_REQUEST.getStatusCode());
    }

    Response response = getSvcClientSvc()
        .proxyPost(ResourceServiceUtils.cleanURI(info).build(), null, agentIds[0]);

    return (Collection<BackupEntity>)response.getEntity();
  }

  @Override
  public Collection<BackupEntity> getBackupStatus(UriInfo info) {
    LOG.info(String.format("Invoking AggregateBackupResourceService.getBackupStatus: %s",
        info.getRequestUri()));

    AggregateCollectionCallback<BackupEntity> callback = new AggregateCollectionCallback<BackupEntity>() {
    };

    return doGet(info, callback, BackupEntity.class);
  }

}
