/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package com.terracotta.management.config.resource.services;

import com.terracotta.management.services.SystemConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * <p>
 * A resource service for configuration of the system settings.
 * </p>
 * 
 * @author Anthony Dahanne
 */
@Path("/config/settings")
public final class SystemConfigResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(SystemConfigResourceService.class);

  private final SystemConfigService systemConfigService;

  public SystemConfigResourceService() {
    this.systemConfigService = ServiceLocator.locate(SystemConfigService.class);
  }

  @GET
  @Path("/authentication")
  @Produces(MediaType.APPLICATION_JSON)
  public String authenticationEnabled() {
    LOG.info("Entering authenticationEnabled (GET)");
    return Boolean.toString(systemConfigService.isAuthenticationEnabled());
  }
  
}
