package com.terracotta.management.config.jaxb.adapters;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.terracotta.management.config.Agent;
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "config")
public final class Config {

  @XmlJavaTypeAdapter(value = MonitoredGroupsAdapter.class)
  private List<Group> monitoredGroups;
  
  @XmlJavaTypeAdapter(value = MonitoredClustersAdapter.class)
  private List<Cluster> monitoredClusters;

  public List<Group> getMonitoredGroups() {
    return monitoredGroups;
  }

  public void setMonitoredGroups(List<Group> monitoredGroups) {
    this.monitoredGroups = monitoredGroups;
  }

  public List<Cluster> getMonitoredClusters() {
    return monitoredClusters;
  }

  public void setMonitoredClusters(List<Cluster> monitoredClusters) {
    this.monitoredClusters = monitoredClusters;
  }

  public Map<String, Collection<Agent>> getMonitored() {

    Map<String, Collection<Agent>> agents = new ConcurrentHashMap<String, Collection<Agent>>();
    if (monitoredGroups != null) {
      for (Group group : monitoredGroups) {
        if (group.getAgents() != null) {
          agents.put(group.getId(), group.getAgents());
        }
      }
    }
    if (monitoredClusters != null) {
      for (Cluster cluster : monitoredClusters) {
        if (cluster.getAgents() != null) {
          agents.put(cluster.getId(), cluster.getAgents());
        }
      }
    }
    return agents;
  }
}
