package com.terracotta.management.config.jaxb.adapters;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import com.terracotta.management.config.Agent;

@XmlAccessorType(XmlAccessType.FIELD)
public class Cluster {
  @XmlAttribute
  private String id;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @XmlElement(name = "agent")
  private List<Agent> agents;

  public List<Agent> getAgents() {
    if (agents == null) {
      return null;
    }
    // this information is not persisted in the agent tag, but needs to be part of the agent model.
    for (Agent agent : agents) {
      agent.setType(Agent.TYPE.TSA);
      agent.setGroupId(id);
    }
    return agents;
    }

  public void setAgents(List<Agent> value) {
    this.agents = value;
    }

}