/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package com.terracotta.management.config;


/**
 * @author Anthony Dahanne
 * This represents the model of the system configuration, global settings
 * 
 */
public class SystemConfig {

  private boolean authenticationEnabled = false;
  private boolean useTmsTruststore = false;
  private boolean firstRun = true;

  public boolean isUseTmsTruststore() {
    return useTmsTruststore;
  }

  public void setUseTmsTrustore(boolean sslEnabled) {
    this.useTmsTruststore = sslEnabled;
  }
  public boolean isAuthenticationEnabled() {
    return authenticationEnabled;
  }
  
  public boolean isFirstRun() {
    return firstRun;
  }

  public void setAuthenticationEnabled(boolean authenticationEnabled) {
    this.authenticationEnabled = authenticationEnabled;
  }

  public void setFirstRun(boolean firstRun) {
    this.firstRun = firstRun;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + (isAuthenticationEnabled() ? 1231 : 1237);
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    SystemConfig other = (SystemConfig) obj;
    return isAuthenticationEnabled() == other.isAuthenticationEnabled();
  }


}
