/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management;

import java.util.Collection;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import net.sf.ehcache.management.resource.ConfigContainerEntity;

import org.terracotta.management.resource.VersionedEntity;

/**
 * A top level wrapper for the aggregation of objects extending {@link VersionedEntity}.
 *
 * @author brandony
 */
@XmlRootElement
@XmlSeeAlso({ConfigContainerEntity.class})
public final class AggregateResourceEnvelope<RESOURCE> {

  private Collection<RESOURCE> aggregateResources;

  public Collection<RESOURCE> getAggregateResources() {
    return aggregateResources;
  }


  public void setAggregateResources(Collection<RESOURCE> configContainers) {
    this.aggregateResources = configContainers;
  }
}
