/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.terracotta.management.resource.Representable;

/**
 * @author brandony
 */
public abstract class AggregateCallback<RESOURCE extends Representable> {
  private Collection<RESOURCE> responses = new ArrayList<RESOURCE>();
  protected List<Exception> exceptions = new ArrayList<Exception>();

  /**
   * <p>
   * Add a collection of entities to be aggregated.
   * </p>
   *
   * @param response a resource to be included in the aggregate resource
   */
  public void addResponse(RESOURCE response) {
    responses.add(response);
  }

  /**
   * <p>
   * Add an exception.
   * </p>
   *
   * @param exception to aggregate
   */
  public void addException(Exception exception) {
    exceptions.add(exception);
  }

  /**
   * <p>
   * Calculate the collection of aggregate results to be returned.
   * </p>
   *
   * @return aggregate result
   */
  public AggregateResourceEnvelope calculateResult() {
    AggregateResourceEnvelope<RESOURCE> envelope = new AggregateResourceEnvelope<RESOURCE>();
    envelope.setAggregateResources(responses);
    return envelope;
  }

  /**
   * <p>
   * Return a copy of the list of exceptions
   * </p>
   *
   * @return aggregate result
   */
  public List<Exception> getExceptions() {
    return Collections.unmodifiableList(exceptions);
  }

}