package com.terracotta.management;

import com.terracotta.management.config.Agent;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author: Anthony Dahanne
 */
public class AgentsUtils {
  public static String checkTsaAgentLocationsAndReturnFirstValidOne(Agent agent) throws MalformedURLException {
    for (String agentLocation : agent.getAgentsLocations()) {
      try {
        new URL(agentLocation);
        return agentLocation;
      } catch (MalformedURLException e1) {
        //some l2 agents may not be known/up yet
      }
    }
    // we did not find a single valid URL ? that's a problem
    throw new MalformedURLException("No valid urls were found for the tsa agent locations");
  }

}
